/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.MongoDBCollectionCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.MongoDBDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputSettingsUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.MongoDBCollectionGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.MongoDBDatabaseGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.ThroughputSettingsGetResultsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MongoDBResourcesInner {
    private MongoDBResourcesService service;
    private CosmosDBImpl client;

    public MongoDBResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (MongoDBResourcesService)retrofit.create(MongoDBResourcesService.class);
        this.client = client;
    }

    public List<MongoDBDatabaseGetResultsInner> listMongoDBDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MongoDBDatabaseGetResultsInner>> listMongoDBDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<MongoDBDatabaseGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<MongoDBDatabaseGetResultsInner>> listMongoDBDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listMongoDBDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<MongoDBDatabaseGetResultsInner>>, List<MongoDBDatabaseGetResultsInner>>(){

            public List<MongoDBDatabaseGetResultsInner> call(ServiceResponse<List<MongoDBDatabaseGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MongoDBDatabaseGetResultsInner>>> listMongoDBDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMongoDBDatabases(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDBDatabaseGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<MongoDBDatabaseGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MongoDBResourcesInner.this.listMongoDBDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MongoDBDatabaseGetResultsInner>> listMongoDBDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MongoDBDatabaseGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBDatabaseGetResultsInner getMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (MongoDBDatabaseGetResultsInner)((Object)((ServiceResponse)this.getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<MongoDBDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>(){

            public MongoDBDatabaseGetResultsInner call(ServiceResponse<MongoDBDatabaseGetResultsInner> response) {
                return (MongoDBDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>> getMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>>>(){

            public Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.getMongoDBDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBDatabaseGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBDatabaseGetResultsInner createUpdateMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return (MongoDBDatabaseGetResultsInner)((Object)((ServiceResponse)this.createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<MongoDBDatabaseGetResultsInner> createUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, ServiceCallback<MongoDBDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters), serviceCallback);
    }

    public Observable<MongoDBDatabaseGetResultsInner> createUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return this.createUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).map((Func1)new Func1<ServiceResponse<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>(){

            public MongoDBDatabaseGetResultsInner call(ServiceResponse<MongoDBDatabaseGetResultsInner> response) {
                return (MongoDBDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>> createUpdateMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateMongoDBDatabaseParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateMongoDBDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDBDatabaseGetResultsInner>(){}.getType());
    }

    public MongoDBDatabaseGetResultsInner beginCreateUpdateMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return (MongoDBDatabaseGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBDatabaseGetResultsInner> beginCreateUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters, ServiceCallback<MongoDBDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters), serviceCallback);
    }

    public Observable<MongoDBDatabaseGetResultsInner> beginCreateUpdateMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return this.beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters).map((Func1)new Func1<ServiceResponse<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>(){

            public MongoDBDatabaseGetResultsInner call(ServiceResponse<MongoDBDatabaseGetResultsInner> response) {
                return (MongoDBDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>> beginCreateUpdateMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateMongoDBDatabaseParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateMongoDBDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>>>(){

            public Observable<ServiceResponse<MongoDBDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.beginCreateUpdateMongoDBDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBDatabaseGetResultsInner> beginCreateUpdateMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBDatabaseGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.deleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteMongoDBDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteMongoDBDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteMongoDBDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.beginDeleteMongoDBDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteMongoDBDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.getMongoDBDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateMongoDBDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateMongoDBDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateMongoDBDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateMongoDBDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.beginUpdateMongoDBDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateMongoDBDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MongoDBCollectionGetResultsInner> listMongoDBCollections(String resourceGroupName, String accountName, String databaseName) {
        return (List)((ServiceResponse)this.listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MongoDBCollectionGetResultsInner>> listMongoDBCollectionsAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<List<MongoDBCollectionGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<List<MongoDBCollectionGetResultsInner>> listMongoDBCollectionsAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.listMongoDBCollectionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<List<MongoDBCollectionGetResultsInner>>, List<MongoDBCollectionGetResultsInner>>(){

            public List<MongoDBCollectionGetResultsInner> call(ServiceResponse<List<MongoDBCollectionGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MongoDBCollectionGetResultsInner>>> listMongoDBCollectionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMongoDBCollections(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MongoDBCollectionGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<MongoDBCollectionGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MongoDBResourcesInner.this.listMongoDBCollectionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MongoDBCollectionGetResultsInner>> listMongoDBCollectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MongoDBCollectionGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBCollectionGetResultsInner getMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return (MongoDBCollectionGetResultsInner)((Object)((ServiceResponse)this.getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBCollectionGetResultsInner> getMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<MongoDBCollectionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<MongoDBCollectionGetResultsInner> getMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.getMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>(){

            public MongoDBCollectionGetResultsInner call(ServiceResponse<MongoDBCollectionGetResultsInner> response) {
                return (MongoDBCollectionGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBCollectionGetResultsInner>> getMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBCollectionGetResultsInner>>>(){

            public Observable<ServiceResponse<MongoDBCollectionGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.getMongoDBCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBCollectionGetResultsInner> getMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBCollectionGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public MongoDBCollectionGetResultsInner createUpdateMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return (MongoDBCollectionGetResultsInner)((Object)((ServiceResponse)this.createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).toBlocking().last()).body());
    }

    public ServiceFuture<MongoDBCollectionGetResultsInner> createUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, ServiceCallback<MongoDBCollectionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters), serviceCallback);
    }

    public Observable<MongoDBCollectionGetResultsInner> createUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return this.createUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).map((Func1)new Func1<ServiceResponse<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>(){

            public MongoDBCollectionGetResultsInner call(ServiceResponse<MongoDBCollectionGetResultsInner> response) {
                return (MongoDBCollectionGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBCollectionGetResultsInner>> createUpdateMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBCollectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateMongoDBCollectionParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", createUpdateMongoDBCollectionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MongoDBCollectionGetResultsInner>(){}.getType());
    }

    public MongoDBCollectionGetResultsInner beginCreateUpdateMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return (MongoDBCollectionGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).toBlocking().single()).body());
    }

    public ServiceFuture<MongoDBCollectionGetResultsInner> beginCreateUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters, ServiceCallback<MongoDBCollectionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters), serviceCallback);
    }

    public Observable<MongoDBCollectionGetResultsInner> beginCreateUpdateMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return this.beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters).map((Func1)new Func1<ServiceResponse<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>(){

            public MongoDBCollectionGetResultsInner call(ServiceResponse<MongoDBCollectionGetResultsInner> response) {
                return (MongoDBCollectionGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MongoDBCollectionGetResultsInner>> beginCreateUpdateMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateMongoDBCollectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateMongoDBCollectionParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", createUpdateMongoDBCollectionParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MongoDBCollectionGetResultsInner>>>(){

            public Observable<ServiceResponse<MongoDBCollectionGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.beginCreateUpdateMongoDBCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MongoDBCollectionGetResultsInner> beginCreateUpdateMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MongoDBCollectionGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        ((ServiceResponse)this.deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<Void> deleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.deleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteMongoDBCollection(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        ((ServiceResponse)this.beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<Void> beginDeleteMongoDBCollectionAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.beginDeleteMongoDBCollectionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteMongoDBCollectionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteMongoDBCollection(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.beginDeleteMongoDBCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteMongoDBCollectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return this.getMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.getMongoDBCollectionThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateMongoDBCollectionThroughput(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateMongoDBCollectionThroughputAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateMongoDBCollectionThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String collectionName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collectionName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateMongoDBCollectionThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, collectionName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MongoDBResourcesInner.this.beginUpdateMongoDBCollectionThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateMongoDBCollectionThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface MongoDBResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources listMongoDBDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases")
        public Observable<Response<ResponseBody>> listMongoDBDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources getMongoDBDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> getMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources createUpdateMongoDBDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> createUpdateMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body MongoDBDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources beginCreateUpdateMongoDBDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body MongoDBDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources deleteMongoDBDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources beginDeleteMongoDBDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteMongoDBDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources getMongoDBDatabaseThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getMongoDBDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources updateMongoDBDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateMongoDBDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources beginUpdateMongoDBDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateMongoDBDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources listMongoDBCollections"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections")
        public Observable<Response<ResponseBody>> listMongoDBCollections(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources getMongoDBCollection"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}")
        public Observable<Response<ResponseBody>> getMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources createUpdateMongoDBCollection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}")
        public Observable<Response<ResponseBody>> createUpdateMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Body MongoDBCollectionCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources beginCreateUpdateMongoDBCollection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Body MongoDBCollectionCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources deleteMongoDBCollection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources beginDeleteMongoDBCollection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteMongoDBCollection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources getMongoDBCollectionThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getMongoDBCollectionThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources updateMongoDBCollectionThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateMongoDBCollectionThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.MongoDBResources beginUpdateMongoDBCollectionThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateMongoDBCollectionThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="collectionName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);
    }
}

