/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.dns.implementation;

import java.util.Map;
import java.util.List;
import com.microsoft.azure.management.dns.ARecord;
import com.microsoft.azure.management.dns.AaaaRecord;
import com.microsoft.azure.management.dns.MxRecord;
import com.microsoft.azure.management.dns.NsRecord;
import com.microsoft.azure.management.dns.PtrRecord;
import com.microsoft.azure.management.dns.SrvRecord;
import com.microsoft.azure.management.dns.TxtRecord;
import com.microsoft.azure.management.dns.CnameRecord;
import com.microsoft.azure.management.dns.SoaRecord;
import com.microsoft.azure.management.dns.CaaRecord;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Describes a DNS record set (a collection of DNS records with the same name
 * and type).
 */
@JsonFlatten
public class RecordSetInner {
    /**
     * The ID of the record set.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /**
     * The name of the record set.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The type of the record set.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * The etag of the record set.
     */
    @JsonProperty(value = "etag")
    private String etag;

    /**
     * The metadata attached to the record set.
     */
    @JsonProperty(value = "properties.metadata")
    private Map<String, String> metadata;

    /**
     * The TTL (time-to-live) of the records in the record set.
     */
    @JsonProperty(value = "properties.TTL")
    private Long tTL;

    /**
     * Fully qualified domain name of the record set.
     */
    @JsonProperty(value = "properties.fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /**
     * The list of A records in the record set.
     */
    @JsonProperty(value = "properties.ARecords")
    private List<ARecord> aRecords;

    /**
     * The list of AAAA records in the record set.
     */
    @JsonProperty(value = "properties.AAAARecords")
    private List<AaaaRecord> aaaaRecords;

    /**
     * The list of MX records in the record set.
     */
    @JsonProperty(value = "properties.MXRecords")
    private List<MxRecord> mxRecords;

    /**
     * The list of NS records in the record set.
     */
    @JsonProperty(value = "properties.NSRecords")
    private List<NsRecord> nsRecords;

    /**
     * The list of PTR records in the record set.
     */
    @JsonProperty(value = "properties.PTRRecords")
    private List<PtrRecord> ptrRecords;

    /**
     * The list of SRV records in the record set.
     */
    @JsonProperty(value = "properties.SRVRecords")
    private List<SrvRecord> srvRecords;

    /**
     * The list of TXT records in the record set.
     */
    @JsonProperty(value = "properties.TXTRecords")
    private List<TxtRecord> txtRecords;

    /**
     * The CNAME record in the  record set.
     */
    @JsonProperty(value = "properties.CNAMERecord")
    private CnameRecord cnameRecord;

    /**
     * The SOA record in the record set.
     */
    @JsonProperty(value = "properties.SOARecord")
    private SoaRecord soaRecord;

    /**
     * The list of CAA records in the record set.
     */
    @JsonProperty(value = "properties.caaRecords")
    private List<CaaRecord> caaRecords;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the etag value.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag value.
     *
     * @param etag the etag value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the metadata value.
     *
     * @return the metadata value
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata value.
     *
     * @param metadata the metadata value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the tTL value.
     *
     * @return the tTL value
     */
    public Long tTL() {
        return this.tTL;
    }

    /**
     * Set the tTL value.
     *
     * @param tTL the tTL value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withTTL(Long tTL) {
        this.tTL = tTL;
        return this;
    }

    /**
     * Get the fqdn value.
     *
     * @return the fqdn value
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the aRecords value.
     *
     * @return the aRecords value
     */
    public List<ARecord> aRecords() {
        return this.aRecords;
    }

    /**
     * Set the aRecords value.
     *
     * @param aRecords the aRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withARecords(List<ARecord> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    /**
     * Get the aaaaRecords value.
     *
     * @return the aaaaRecords value
     */
    public List<AaaaRecord> aaaaRecords() {
        return this.aaaaRecords;
    }

    /**
     * Set the aaaaRecords value.
     *
     * @param aaaaRecords the aaaaRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withAaaaRecords(List<AaaaRecord> aaaaRecords) {
        this.aaaaRecords = aaaaRecords;
        return this;
    }

    /**
     * Get the mxRecords value.
     *
     * @return the mxRecords value
     */
    public List<MxRecord> mxRecords() {
        return this.mxRecords;
    }

    /**
     * Set the mxRecords value.
     *
     * @param mxRecords the mxRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withMxRecords(List<MxRecord> mxRecords) {
        this.mxRecords = mxRecords;
        return this;
    }

    /**
     * Get the nsRecords value.
     *
     * @return the nsRecords value
     */
    public List<NsRecord> nsRecords() {
        return this.nsRecords;
    }

    /**
     * Set the nsRecords value.
     *
     * @param nsRecords the nsRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withNsRecords(List<NsRecord> nsRecords) {
        this.nsRecords = nsRecords;
        return this;
    }

    /**
     * Get the ptrRecords value.
     *
     * @return the ptrRecords value
     */
    public List<PtrRecord> ptrRecords() {
        return this.ptrRecords;
    }

    /**
     * Set the ptrRecords value.
     *
     * @param ptrRecords the ptrRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withPtrRecords(List<PtrRecord> ptrRecords) {
        this.ptrRecords = ptrRecords;
        return this;
    }

    /**
     * Get the srvRecords value.
     *
     * @return the srvRecords value
     */
    public List<SrvRecord> srvRecords() {
        return this.srvRecords;
    }

    /**
     * Set the srvRecords value.
     *
     * @param srvRecords the srvRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withSrvRecords(List<SrvRecord> srvRecords) {
        this.srvRecords = srvRecords;
        return this;
    }

    /**
     * Get the txtRecords value.
     *
     * @return the txtRecords value
     */
    public List<TxtRecord> txtRecords() {
        return this.txtRecords;
    }

    /**
     * Set the txtRecords value.
     *
     * @param txtRecords the txtRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withTxtRecords(List<TxtRecord> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    /**
     * Get the cnameRecord value.
     *
     * @return the cnameRecord value
     */
    public CnameRecord cnameRecord() {
        return this.cnameRecord;
    }

    /**
     * Set the cnameRecord value.
     *
     * @param cnameRecord the cnameRecord value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withCnameRecord(CnameRecord cnameRecord) {
        this.cnameRecord = cnameRecord;
        return this;
    }

    /**
     * Get the soaRecord value.
     *
     * @return the soaRecord value
     */
    public SoaRecord soaRecord() {
        return this.soaRecord;
    }

    /**
     * Set the soaRecord value.
     *
     * @param soaRecord the soaRecord value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withSoaRecord(SoaRecord soaRecord) {
        this.soaRecord = soaRecord;
        return this;
    }

    /**
     * Get the caaRecords value.
     *
     * @return the caaRecords value
     */
    public List<CaaRecord> caaRecords() {
        return this.caaRecords;
    }

    /**
     * Set the caaRecords value.
     *
     * @param caaRecords the caaRecords value to set
     * @return the RecordSetInner object itself.
     */
    public RecordSetInner withCaaRecords(List<CaaRecord> caaRecords) {
        this.caaRecords = caaRecords;
        return this;
    }

}
