/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.dns.ZoneUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Zones.
 */
public class ZonesInner implements InnerSupportsGet<ZoneInner>, InnerSupportsDelete<Void>, InnerSupportsListing<ZoneInner> {
    /** The Retrofit service to perform REST calls. */
    private ZonesService service;
    /** The service client containing this operation class. */
    private DnsManagementClientImpl client;

    /**
     * Initializes an instance of ZonesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ZonesInner(Retrofit retrofit, DnsManagementClientImpl client) {
        this.service = retrofit.create(ZonesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Zones to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ZonesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("subscriptionId") String subscriptionId, @Body ZoneInner parameters, @Header("If-Match") String ifMatch, @Header("If-None-Match") String ifNoneMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("subscriptionId") String subscriptionId, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("subscriptionId") String subscriptionId, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("subscriptionId") String subscriptionId, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ZoneUpdate parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Network/dnszones")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("$top") Integer top, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ZoneInner object if successful.
     */
    public ZoneInner createOrUpdate(String resourceGroupName, String zoneName, ZoneInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters, final ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters).map(new Func1<ServiceResponse<ZoneInner>, ZoneInner>() {
            @Override
            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ServiceResponse<ZoneInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, ZoneInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return service.createOrUpdate(resourceGroupName, zoneName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>() {
                @Override
                public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ZoneInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new DNS zone to be created, but to prevent updating an existing zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ZoneInner object if successful.
     */
    public ZoneInner createOrUpdate(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters, ifMatch, ifNoneMatch).toBlocking().single().body();
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new DNS zone to be created, but to prevent updating an existing zone. Other values will be ignored.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch, final ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new DNS zone to be created, but to prevent updating an existing zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters, ifMatch, ifNoneMatch).map(new Func1<ServiceResponse<ZoneInner>, ZoneInner>() {
            @Override
            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new DNS zone to be created, but to prevent updating an existing zone. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ServiceResponse<ZoneInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdate(resourceGroupName, zoneName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>() {
                @Override
                public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ZoneInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ZoneInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ZoneInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ZoneInner>() { }.getType())
                .register(201, new TypeToken<ZoneInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String zoneName) {
        deleteWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().last().body();
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName) {
        return deleteWithServiceResponseAsync(resourceGroupName, zoneName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String ifMatch = null;
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }
    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String zoneName, String ifMatch) {
        deleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).toBlocking().last().body();
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, String ifMatch, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch), serviceCallback);
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName, String ifMatch) {
        return deleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String zoneName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().single().body();
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String zoneName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String zoneName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String ifMatch = null;
        return service.beginDelete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String zoneName, String ifMatch) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).toBlocking().single().body();
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String zoneName, String ifMatch, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch), serviceCallback);
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String zoneName, String ifMatch) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a DNS zone. WARNING: All DNS records in the zone will also be deleted. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always delete the current zone. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a DNS zone. Retrieves the zone properties, but not the record sets within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ZoneInner object if successful.
     */
    public ZoneInner getByResourceGroup(String resourceGroupName, String zoneName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().single().body();
    }

    /**
     * Gets a DNS zone. Retrieves the zone properties, but not the record sets within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ZoneInner> getByResourceGroupAsync(String resourceGroupName, String zoneName, final ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    /**
     * Gets a DNS zone. Retrieves the zone properties, but not the record sets within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ZoneInner> getByResourceGroupAsync(String resourceGroupName, String zoneName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, zoneName).map(new Func1<ServiceResponse<ZoneInner>, ZoneInner>() {
            @Override
            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a DNS zone. Retrieves the zone properties, but not the record sets within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ServiceResponse<ZoneInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, zoneName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>() {
                @Override
                public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ZoneInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ZoneInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ZoneInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ZoneInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ZoneInner object if successful.
     */
    public ZoneInner update(String resourceGroupName, String zoneName) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().single().body();
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ZoneInner> updateAsync(String resourceGroupName, String zoneName, final ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ZoneInner> updateAsync(String resourceGroupName, String zoneName) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName).map(new Func1<ServiceResponse<ZoneInner>, ZoneInner>() {
            @Override
            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ServiceResponse<ZoneInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String ifMatch = null;
        final Map<String, String> tags = null;
        ZoneUpdate parameters = new ZoneUpdate();
        parameters.withTags(null);
        return service.update(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>() {
                @Override
                public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ZoneInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ZoneInner object if successful.
     */
    public ZoneInner update(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch, tags).toBlocking().single().body();
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ZoneInner> updateAsync(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags, final ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch, tags), serviceCallback);
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ZoneInner> updateAsync(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch, tags).map(new Func1<ServiceResponse<ZoneInner>, ZoneInner>() {
            @Override
            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a DNS zone. Does not modify DNS records within the zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param ifMatch The etag of the DNS zone. Omit this value to always overwrite the current zone. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ZoneInner object
     */
    public Observable<ServiceResponse<ZoneInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        ZoneUpdate parameters = new ZoneUpdate();
        parameters.withTags(tags);
        return service.update(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>() {
                @Override
                public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ZoneInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ZoneInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ZoneInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ZoneInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ZoneInner&gt; object if successful.
     */
    public PagedList<ZoneInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<ZoneInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ZoneInner>(response.body()) {
            @Override
            public Page<ZoneInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ZoneInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<Page<ZoneInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>() {
                @Override
                public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ZoneInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer top = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ZoneInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ZoneInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ZoneInner&gt; object if successful.
     */
    public PagedList<ZoneInner> listByResourceGroup(final String resourceGroupName, final Integer top) {
        ServiceResponse<Page<ZoneInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, top).toBlocking().single();
        return new PagedList<ZoneInner>(response.body()) {
            @Override
            public Page<ZoneInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ZoneInner>> listByResourceGroupAsync(final String resourceGroupName, final Integer top, final ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, top),
            new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<Page<ZoneInner>> listByResourceGroupAsync(final String resourceGroupName, final Integer top) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, top)
            .map(new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>() {
                @Override
                public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final Integer top) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, top)
            .concatMap(new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
    ServiceResponse<PageImpl<ZoneInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<ZoneInner>> * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ZoneInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ZoneInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ZoneInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ZoneInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ZoneInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ZoneInner&gt; object if successful.
     */
    public PagedList<ZoneInner> list() {
        ServiceResponse<Page<ZoneInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ZoneInner>(response.body()) {
            @Override
            public Page<ZoneInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ZoneInner>> listAsync(final ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<Page<ZoneInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>() {
                @Override
                public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ZoneInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer top = null;
        return service.list(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ZoneInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ZoneInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ZoneInner&gt; object if successful.
     */
    public PagedList<ZoneInner> list(final Integer top) {
        ServiceResponse<Page<ZoneInner>> response = listSinglePageAsync(top).toBlocking().single();
        return new PagedList<ZoneInner>(response.body()) {
            @Override
            public Page<ZoneInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ZoneInner>> listAsync(final Integer top, final ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(top),
            new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<Page<ZoneInner>> listAsync(final Integer top) {
        return listWithServiceResponseAsync(top)
            .map(new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>() {
                @Override
                public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param top The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listWithServiceResponseAsync(final Integer top) {
        return listSinglePageAsync(top)
            .concatMap(new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
    ServiceResponse<PageImpl<ZoneInner>> * @param top The maximum number of DNS zones to return. If not specified, returns up to 100 zones.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ZoneInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listSinglePageAsync(final Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ZoneInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ZoneInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ZoneInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ZoneInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ZoneInner&gt; object if successful.
     */
    public PagedList<ZoneInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<ZoneInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ZoneInner>(response.body()) {
            @Override
            public Page<ZoneInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ZoneInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<ZoneInner>> serviceFuture, final ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<Page<ZoneInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>() {
                @Override
                public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the DNS zones within a resource group.
     *
    ServiceResponse<PageImpl<ZoneInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ZoneInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ZoneInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ZoneInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ZoneInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ZoneInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ZoneInner&gt; object if successful.
     */
    public PagedList<ZoneInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ZoneInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ZoneInner>(response.body()) {
            @Override
            public Page<ZoneInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ZoneInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ZoneInner>> serviceFuture, final ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<Page<ZoneInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>() {
                @Override
                public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ZoneInner&gt; object
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the DNS zones in all resource groups in a subscription.
     *
    ServiceResponse<PageImpl<ZoneInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ZoneInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ZoneInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ZoneInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ZoneInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ZoneInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ZoneInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
