/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplication;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.CertificateCredentialImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.HasCredential;
import com.microsoft.azure.management.graphrbac.implementation.KeyCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialImpl;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ServicePrincipalImpl
extends CreatableUpdatableImpl<ServicePrincipal, ServicePrincipalInner, ServicePrincipalImpl>
implements ServicePrincipal,
ServicePrincipal.Definition,
ServicePrincipal.Update,
HasCredential<ServicePrincipalImpl> {
    private GraphRbacManager manager;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;
    private Map<String, RoleAssignment> cachedRoleAssignments;
    private ServicePrincipalCreateParametersInner createParameters;
    private Creatable<ActiveDirectoryApplication> applicationCreatable;
    private Map<String, BuiltInRole> rolesToCreate;
    private Set<String> rolesToDelete;
    String assignedSubscription;
    private List<CertificateCredentialImpl<?>> certificateCredentialsToCreate;
    private List<PasswordCredentialImpl<?>> passwordCredentialsToCreate;
    private Set<String> certificateCredentialsToDelete;
    private Set<String> passwordCredentialsToDelete;

    ServicePrincipalImpl(ServicePrincipalInner innerObject, GraphRbacManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new ServicePrincipalCreateParametersInner().withAccountEnabled(true);
        this.cachedRoleAssignments = new HashMap<String, RoleAssignment>();
        this.rolesToCreate = new HashMap<String, BuiltInRole>();
        this.rolesToDelete = new HashSet<String>();
        this.cachedCertificateCredentials = new HashMap<String, CertificateCredential>();
        this.certificateCredentialsToCreate = new ArrayList();
        this.certificateCredentialsToDelete = new HashSet<String>();
        this.cachedPasswordCredentials = new HashMap<String, PasswordCredential>();
        this.passwordCredentialsToCreate = new ArrayList();
        this.passwordCredentialsToDelete = new HashSet<String>();
    }

    public String id() {
        return ((ServicePrincipalInner)this.inner()).objectId();
    }

    @Override
    public String applicationId() {
        return ((ServicePrincipalInner)this.inner()).appId();
    }

    @Override
    public List<String> servicePrincipalNames() {
        return ((ServicePrincipalInner)this.inner()).servicePrincipalNames();
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    @Override
    public Set<RoleAssignment> roleAssignments() {
        return Collections.unmodifiableSet(new HashSet<RoleAssignment>(this.cachedRoleAssignments.values()));
    }

    protected Observable<ServicePrincipalInner> getInnerAsync() {
        return this.manager.inner().servicePrincipals().getAsync(this.id());
    }

    public Observable<ServicePrincipal> createResourceAsync() {
        Observable sp = Observable.just((Object)this);
        if (this.isInCreateMode()) {
            if (this.applicationCreatable != null) {
                ActiveDirectoryApplication application = (ActiveDirectoryApplication)this.taskResult(this.applicationCreatable.key());
                this.createParameters.withAppId(application.applicationId());
            }
            sp = this.manager.inner().servicePrincipals().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        return sp.flatMap((Func1)new Func1<ServicePrincipal, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipal servicePrincipal) {
                return ServicePrincipalImpl.this.submitCredentialsAsync(servicePrincipal).mergeWith(ServicePrincipalImpl.this.submitRolesAsync(servicePrincipal));
            }
        }).map((Func1)new Func1<ServicePrincipal, ServicePrincipal>(){

            public ServicePrincipal call(ServicePrincipal servicePrincipal) {
                for (PasswordCredentialImpl passwordCredential : ServicePrincipalImpl.this.passwordCredentialsToCreate) {
                    passwordCredential.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
                }
                for (CertificateCredentialImpl certificateCredential : ServicePrincipalImpl.this.certificateCredentialsToCreate) {
                    certificateCredential.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
                }
                ServicePrincipalImpl.this.passwordCredentialsToCreate.clear();
                ServicePrincipalImpl.this.certificateCredentialsToCreate.clear();
                return servicePrincipal;
            }
        });
    }

    private Observable<ServicePrincipal> submitCredentialsAsync(ServicePrincipal sp) {
        Observable observable = Observable.just(null);
        if (!this.certificateCredentialsToCreate.isEmpty() || !this.certificateCredentialsToDelete.isEmpty()) {
            HashMap<String, CertificateCredential> newCerts = new HashMap<String, CertificateCredential>(this.cachedCertificateCredentials);
            for (String string : this.certificateCredentialsToDelete) {
                newCerts.remove(string);
            }
            for (CertificateCredential certificateCredential : this.certificateCredentialsToCreate) {
                newCerts.put(certificateCredential.name(), certificateCredential);
            }
            observable = observable.mergeWith(this.manager().inner().servicePrincipals().updateKeyCredentialsAsync(sp.id(), Lists.transform(new ArrayList(newCerts.values()), (Function)new Function<CertificateCredential, KeyCredentialInner>(){

                public KeyCredentialInner apply(CertificateCredential input) {
                    return (KeyCredentialInner)input.inner();
                }
            })));
        }
        if (!this.passwordCredentialsToCreate.isEmpty() || !this.passwordCredentialsToDelete.isEmpty()) {
            HashMap<String, PasswordCredential> newPasses = new HashMap<String, PasswordCredential>(this.cachedPasswordCredentials);
            for (String string : this.passwordCredentialsToDelete) {
                newPasses.remove(string);
            }
            for (PasswordCredential passwordCredential : this.passwordCredentialsToCreate) {
                newPasses.put(passwordCredential.name(), passwordCredential);
            }
            observable = observable.mergeWith(this.manager().inner().servicePrincipals().updatePasswordCredentialsAsync(sp.id(), Lists.transform(new ArrayList(newPasses.values()), (Function)new Function<PasswordCredential, PasswordCredentialInner>(){

                public PasswordCredentialInner apply(PasswordCredential input) {
                    return (PasswordCredentialInner)input.inner();
                }
            })));
        }
        return observable.last().flatMap((Func1)new Func1<Void, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(Void aVoid) {
                ServicePrincipalImpl.this.passwordCredentialsToDelete.clear();
                ServicePrincipalImpl.this.certificateCredentialsToDelete.clear();
                return ServicePrincipalImpl.this.refreshCredentialsAsync();
            }
        });
    }

    private Observable<ServicePrincipal> submitRolesAsync(final ServicePrincipal servicePrincipal) {
        Observable create = this.rolesToCreate.isEmpty() ? Observable.just((Object)servicePrincipal) : Observable.from(this.rolesToCreate.entrySet()).flatMap((Func1)new Func1<Map.Entry<String, BuiltInRole>, Observable<Indexable>>(){

            public Observable<Indexable> call(Map.Entry<String, BuiltInRole> role) {
                return ((RoleAssignment.DefinitionStages.Blank)ServicePrincipalImpl.this.manager().roleAssignments().define(SdkContext.randomUuid())).forServicePrincipal(servicePrincipal).withBuiltInRole(role.getValue()).withScope(role.getKey()).createAsync();
            }
        }).doOnNext((Action1)new Action1<Indexable>(){

            public void call(Indexable o) {
                ServicePrincipalImpl.this.cachedRoleAssignments.put(((RoleAssignment)o).id(), (RoleAssignment)o);
            }
        }).last().map((Func1)new Func1<Indexable, ServicePrincipal>(){

            public ServicePrincipal call(Indexable o) {
                ServicePrincipalImpl.this.rolesToCreate.clear();
                return servicePrincipal;
            }
        });
        Observable delete = this.rolesToDelete.isEmpty() ? Observable.just((Object)servicePrincipal) : Observable.from(this.rolesToDelete).flatMap((Func1)new Func1<String, Observable<String>>(){

            public Observable<String> call(final String s) {
                return ServicePrincipalImpl.this.manager().roleAssignments().deleteByIdAsync(((RoleAssignment)ServicePrincipalImpl.this.cachedRoleAssignments.get(s)).id()).toSingle((Func0)new Func0<String>(){

                    public String call() {
                        return s;
                    }
                }).toObservable();
            }
        }).doOnNext((Action1)new Action1<String>(){

            public void call(String s) {
                ServicePrincipalImpl.this.cachedRoleAssignments.remove(s);
            }
        }).last().map((Func1)new Func1<Object, ServicePrincipal>(){

            public ServicePrincipal call(Object o) {
                ServicePrincipalImpl.this.rolesToDelete.clear();
                return servicePrincipal;
            }
        });
        return create.mergeWith(delete).last();
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    Observable<ServicePrincipal> refreshCredentialsAsync() {
        Observable keyCredentials = this.manager.inner().servicePrincipals().listKeyCredentialsAsync(this.id()).map((Func1)new Func1<List<KeyCredentialInner>, Map<String, CertificateCredential>>(){

            public Map<String, CertificateCredential> call(List<KeyCredentialInner> keyCredentialInners) {
                if (keyCredentialInners == null || keyCredentialInners.isEmpty()) {
                    return Collections.emptyMap();
                }
                HashMap<String, CertificateCredential> certificateCredentialMap = new HashMap<String, CertificateCredential>();
                for (KeyCredentialInner inner : keyCredentialInners) {
                    CertificateCredentialImpl credential = new CertificateCredentialImpl(inner);
                    certificateCredentialMap.put(credential.name(), credential);
                }
                return certificateCredentialMap;
            }
        }).map((Func1)new Func1<Map<String, CertificateCredential>, ServicePrincipal>(){

            public ServicePrincipal call(Map<String, CertificateCredential> stringCertificateCredentialMap) {
                ServicePrincipalImpl.this.cachedCertificateCredentials = stringCertificateCredentialMap;
                return ServicePrincipalImpl.this;
            }
        });
        Observable passwordCredentials = this.manager.inner().servicePrincipals().listPasswordCredentialsAsync(this.id()).map((Func1)new Func1<List<PasswordCredentialInner>, Map<String, PasswordCredential>>(){

            public Map<String, PasswordCredential> call(List<PasswordCredentialInner> passwordCredentialInners) {
                if (passwordCredentialInners == null || passwordCredentialInners.isEmpty()) {
                    return Collections.emptyMap();
                }
                HashMap<String, PasswordCredential> passwordCredentialMap = new HashMap<String, PasswordCredential>();
                for (PasswordCredentialInner inner : passwordCredentialInners) {
                    PasswordCredentialImpl credential = new PasswordCredentialImpl(inner);
                    passwordCredentialMap.put(credential.name(), credential);
                }
                return passwordCredentialMap;
            }
        }).map((Func1)new Func1<Map<String, PasswordCredential>, ServicePrincipal>(){

            public ServicePrincipal call(Map<String, PasswordCredential> stringPasswordCredentialMap) {
                ServicePrincipalImpl.this.cachedPasswordCredentials = stringPasswordCredentialMap;
                return ServicePrincipalImpl.this;
            }
        });
        return keyCredentials.mergeWith(passwordCredentials).last();
    }

    public Observable<ServicePrincipal> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<ServicePrincipal, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipal application) {
                return ServicePrincipalImpl.this.refreshCredentialsAsync();
            }
        });
    }

    public CertificateCredentialImpl defineCertificateCredential(String name) {
        return new CertificateCredentialImpl(name, this);
    }

    public PasswordCredentialImpl definePasswordCredential(String name) {
        return new PasswordCredentialImpl(name, this);
    }

    @Override
    public ServicePrincipalImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name)) {
            this.passwordCredentialsToDelete.add(name);
        } else if (this.cachedCertificateCredentials.containsKey(name)) {
            this.certificateCredentialsToDelete.add(name);
        }
        return this;
    }

    @Override
    public ServicePrincipalImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        this.certificateCredentialsToCreate.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        this.passwordCredentialsToCreate.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(String id) {
        this.createParameters.withAppId(id);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(ActiveDirectoryApplication application) {
        this.createParameters.withAppId(application.applicationId());
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(Creatable<ActiveDirectoryApplication> applicationCreatable) {
        this.addDependency(applicationCreatable);
        this.applicationCreatable = applicationCreatable;
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(String signOnUrl) {
        return this.withNewApplication(((ActiveDirectoryApplication.DefinitionStages.Blank)this.manager.applications().define(this.name())).withSignOnUrl(signOnUrl).withIdentifierUrl(signOnUrl));
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    @Override
    public ServicePrincipalImpl withNewRole(BuiltInRole role, String scope) {
        this.rolesToCreate.put(scope, role);
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewRoleInSubscription(BuiltInRole role, String subscriptionId) {
        this.assignedSubscription = subscriptionId;
        return this.withNewRole(role, "subscriptions/" + subscriptionId);
    }

    @Override
    public ServicePrincipalImpl withNewRoleInResourceGroup(BuiltInRole role, ResourceGroup resourceGroup) {
        return this.withNewRole(role, resourceGroup.id());
    }

    @Override
    public ServicePrincipal.Update withoutRole(RoleAssignment roleAssignment) {
        this.rolesToDelete.add(roleAssignment.id());
        return this;
    }
}

