/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines how often to run the search and the time interval.
 */
public class Schedule {
    /**
     * frequency (in minutes) at which rule condition should be evaluated.
     */
    @JsonProperty(value = "frequencyInMinutes", required = true)
    private int frequencyInMinutes;

    /**
     * Time window for which data needs to be fetched for query (should be
     * greater than or equal to frequencyInMinutes).
     */
    @JsonProperty(value = "timeWindowInMinutes", required = true)
    private int timeWindowInMinutes;

    /**
     * Get frequency (in minutes) at which rule condition should be evaluated.
     *
     * @return the frequencyInMinutes value
     */
    public int frequencyInMinutes() {
        return this.frequencyInMinutes;
    }

    /**
     * Set frequency (in minutes) at which rule condition should be evaluated.
     *
     * @param frequencyInMinutes the frequencyInMinutes value to set
     * @return the Schedule object itself.
     */
    public Schedule withFrequencyInMinutes(int frequencyInMinutes) {
        this.frequencyInMinutes = frequencyInMinutes;
        return this;
    }

    /**
     * Get time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
     *
     * @return the timeWindowInMinutes value
     */
    public int timeWindowInMinutes() {
        return this.timeWindowInMinutes;
    }

    /**
     * Set time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
     *
     * @param timeWindowInMinutes the timeWindowInMinutes value to set
     * @return the Schedule object itself.
     */
    public Schedule withTimeWindowInMinutes(int timeWindowInMinutes) {
        this.timeWindowInMinutes = timeWindowInMinutes;
        return this;
    }

}
