/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The condition that results in the Log Search rule.
 */
public class TriggerCondition {
    /**
     * Evaluation operation for rule - 'GreaterThan' or 'LessThan. Possible
     * values include: 'GreaterThan', 'LessThan', 'Equal'.
     */
    @JsonProperty(value = "thresholdOperator", required = true)
    private ConditionalOperator thresholdOperator;

    /**
     * Result or count threshold based on which rule should be triggered.
     */
    @JsonProperty(value = "threshold", required = true)
    private double threshold;

    /**
     * Trigger condition for metric query rule.
     */
    @JsonProperty(value = "metricTrigger")
    private LogMetricTrigger metricTrigger;

    /**
     * Get evaluation operation for rule - 'GreaterThan' or 'LessThan. Possible values include: 'GreaterThan', 'LessThan', 'Equal'.
     *
     * @return the thresholdOperator value
     */
    public ConditionalOperator thresholdOperator() {
        return this.thresholdOperator;
    }

    /**
     * Set evaluation operation for rule - 'GreaterThan' or 'LessThan. Possible values include: 'GreaterThan', 'LessThan', 'Equal'.
     *
     * @param thresholdOperator the thresholdOperator value to set
     * @return the TriggerCondition object itself.
     */
    public TriggerCondition withThresholdOperator(ConditionalOperator thresholdOperator) {
        this.thresholdOperator = thresholdOperator;
        return this;
    }

    /**
     * Get result or count threshold based on which rule should be triggered.
     *
     * @return the threshold value
     */
    public double threshold() {
        return this.threshold;
    }

    /**
     * Set result or count threshold based on which rule should be triggered.
     *
     * @param threshold the threshold value to set
     * @return the TriggerCondition object itself.
     */
    public TriggerCondition withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get trigger condition for metric query rule.
     *
     * @return the metricTrigger value
     */
    public LogMetricTrigger metricTrigger() {
        return this.metricTrigger;
    }

    /**
     * Set trigger condition for metric query rule.
     *
     * @param metricTrigger the metricTrigger value to set
     * @return the TriggerCondition object itself.
     */
    public TriggerCondition withMetricTrigger(LogMetricTrigger metricTrigger) {
        this.metricTrigger = metricTrigger;
        return this;
    }

}
