/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A voice receiver.
 */
public class VoiceReceiver {
    /**
     * The name of the voice receiver. Names must be unique across all
     * receivers within an action group.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The country code of the voice receiver.
     */
    @JsonProperty(value = "countryCode", required = true)
    private String countryCode;

    /**
     * The phone number of the voice receiver.
     */
    @JsonProperty(value = "phoneNumber", required = true)
    private String phoneNumber;

    /**
     * Get the name of the voice receiver. Names must be unique across all receivers within an action group.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name of the voice receiver. Names must be unique across all receivers within an action group.
     *
     * @param name the name value to set
     * @return the VoiceReceiver object itself.
     */
    public VoiceReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the country code of the voice receiver.
     *
     * @return the countryCode value
     */
    public String countryCode() {
        return this.countryCode;
    }

    /**
     * Set the country code of the voice receiver.
     *
     * @param countryCode the countryCode value to set
     * @return the VoiceReceiver object itself.
     */
    public VoiceReceiver withCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    /**
     * Get the phone number of the voice receiver.
     *
     * @return the phoneNumber value
     */
    public String phoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Set the phone number of the voice receiver.
     *
     * @param phoneNumber the phoneNumber value to set
     * @return the VoiceReceiver object itself.
     */
    public VoiceReceiver withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

}
