/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.base.Strings;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.AutoscaleProfile;
import com.microsoft.azure.management.monitor.DayOfWeek;
import com.microsoft.azure.management.monitor.Recurrence;
import com.microsoft.azure.management.monitor.RecurrenceFrequency;
import com.microsoft.azure.management.monitor.RecurrentSchedule;
import com.microsoft.azure.management.monitor.ScaleCapacity;
import com.microsoft.azure.management.monitor.ScaleRule;
import com.microsoft.azure.management.monitor.TimeWindow;
import com.microsoft.azure.management.monitor.implementation.AutoscaleProfileInner;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingImpl;
import com.microsoft.azure.management.monitor.implementation.ScaleRuleImpl;
import com.microsoft.azure.management.monitor.implementation.ScaleRuleInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

@LangDefinition
class AutoscaleProfileImpl
extends WrapperImpl<AutoscaleProfileInner>
implements AutoscaleProfile,
AutoscaleProfile.Definition,
AutoscaleProfile.UpdateDefinition,
AutoscaleProfile.Update {
    private final AutoscaleSettingImpl parent;

    AutoscaleProfileImpl(String name, AutoscaleProfileInner innerObject, AutoscaleSettingImpl parent) {
        super((Object)innerObject);
        ((AutoscaleProfileInner)this.inner()).withName(name);
        this.parent = parent;
        if (((AutoscaleProfileInner)this.inner()).capacity() == null) {
            ((AutoscaleProfileInner)this.inner()).withCapacity(new ScaleCapacity());
        }
        if (((AutoscaleProfileInner)this.inner()).rules() == null) {
            ((AutoscaleProfileInner)this.inner()).withRules(new ArrayList<ScaleRuleInner>());
        }
    }

    public String name() {
        return ((AutoscaleProfileInner)this.inner()).name();
    }

    @Override
    public int minInstanceCount() {
        if (((AutoscaleProfileInner)this.inner()).capacity() != null) {
            return Integer.parseInt(((AutoscaleProfileInner)this.inner()).capacity().minimum());
        }
        return 0;
    }

    @Override
    public int maxInstanceCount() {
        if (((AutoscaleProfileInner)this.inner()).capacity() != null) {
            return Integer.parseInt(((AutoscaleProfileInner)this.inner()).capacity().maximum());
        }
        return 0;
    }

    @Override
    public int defaultInstanceCount() {
        if (((AutoscaleProfileInner)this.inner()).capacity() != null) {
            return Integer.parseInt(((AutoscaleProfileInner)this.inner()).capacity().defaultProperty());
        }
        return 0;
    }

    @Override
    public TimeWindow fixedDateSchedule() {
        return ((AutoscaleProfileInner)this.inner()).fixedDate();
    }

    @Override
    public Recurrence recurrentSchedule() {
        return ((AutoscaleProfileInner)this.inner()).recurrence();
    }

    @Override
    public List<ScaleRule> rules() {
        ArrayList<ScaleRule> rules = new ArrayList<ScaleRule>();
        if (((AutoscaleProfileInner)this.inner()).rules() != null) {
            for (ScaleRuleInner ruleInner : ((AutoscaleProfileInner)this.inner()).rules()) {
                rules.add(new ScaleRuleImpl(ruleInner, this));
            }
        }
        return rules;
    }

    public AutoscaleSettingImpl parent() {
        return this.parent;
    }

    public AutoscaleSettingImpl attach() {
        return this.parent.addNewAutoscaleProfile(this);
    }

    @Override
    public AutoscaleProfileImpl withMetricBasedScale(int minimumInstanceCount, int maximumInstanceCount, int defaultInstanceCount) {
        ((AutoscaleProfileInner)this.inner()).capacity().withMinimum(Integer.toString(minimumInstanceCount));
        ((AutoscaleProfileInner)this.inner()).capacity().withMaximum(Integer.toString(maximumInstanceCount));
        ((AutoscaleProfileInner)this.inner()).capacity().withDefaultProperty(Integer.toString(defaultInstanceCount));
        return this;
    }

    @Override
    public AutoscaleProfileImpl withScheduleBasedScale(int instanceCount) {
        return this.withMetricBasedScale(instanceCount, instanceCount, instanceCount);
    }

    @Override
    public AutoscaleProfileImpl withFixedInstanceCount(int instanceCount) {
        this.withMetricBasedScale(instanceCount, instanceCount, instanceCount);
        ((AutoscaleProfileInner)this.inner()).withFixedDate(null);
        ((AutoscaleProfileInner)this.inner()).withRecurrence(null);
        ((AutoscaleProfileInner)this.inner()).withRules(new ArrayList<ScaleRuleInner>());
        return this;
    }

    @Override
    public AutoscaleProfileImpl withFixedDateSchedule(String timeZone, DateTime start, DateTime end) {
        ((AutoscaleProfileInner)this.inner()).withFixedDate(new TimeWindow().withTimeZone(timeZone).withStart(start).withEnd(end));
        if (((AutoscaleProfileInner)this.inner()).recurrence() != null) {
            ((AutoscaleProfileInner)this.inner()).withRecurrence(null);
        }
        return this;
    }

    @Override
    public AutoscaleProfileImpl withRecurrentSchedule(String scheduleTimeZone, String startTime, DayOfWeek ... weekday) {
        if (!(!Strings.isNullOrEmpty((String)startTime) && startTime.length() == 5 && startTime.charAt(2) == ':' && Character.isDigit(startTime.charAt(0)) && Character.isDigit(startTime.charAt(1)) && Character.isDigit(startTime.charAt(3)) && Character.isDigit(startTime.charAt(4)))) {
            throw new IllegalArgumentException("Start time should have format of 'hh:mm' where hh is in 24-hour clock (AM/PM times are not supported).");
        }
        int hh = Integer.parseInt(startTime.substring(0, 2));
        int mm = Integer.parseInt(startTime.substring(3));
        if (hh > 23 || mm > 60) {
            throw new IllegalArgumentException("Start time should have format of 'hh:mm' where hh is in 24-hour clock (AM/PM times are not supported).");
        }
        ((AutoscaleProfileInner)this.inner()).withRecurrence(new Recurrence());
        ((AutoscaleProfileInner)this.inner()).recurrence().withFrequency(RecurrenceFrequency.WEEK);
        ((AutoscaleProfileInner)this.inner()).recurrence().withSchedule(new RecurrentSchedule());
        ((AutoscaleProfileInner)this.inner()).recurrence().schedule().withTimeZone(scheduleTimeZone);
        ((AutoscaleProfileInner)this.inner()).recurrence().schedule().withHours(new ArrayList<Integer>());
        ((AutoscaleProfileInner)this.inner()).recurrence().schedule().withMinutes(new ArrayList<Integer>());
        ((AutoscaleProfileInner)this.inner()).recurrence().schedule().hours().add(hh);
        ((AutoscaleProfileInner)this.inner()).recurrence().schedule().minutes().add(mm);
        ((AutoscaleProfileInner)this.inner()).recurrence().schedule().withDays(new ArrayList<String>());
        for (DayOfWeek dof : weekday) {
            ((AutoscaleProfileInner)this.inner()).recurrence().schedule().days().add(dof.toString());
        }
        ((AutoscaleProfileInner)this.inner()).withFixedDate(null);
        return this;
    }

    @Override
    public ScaleRuleImpl defineScaleRule() {
        return new ScaleRuleImpl(new ScaleRuleInner(), this);
    }

    @Override
    public ScaleRuleImpl updateScaleRule(int ruleIndex) {
        ScaleRuleImpl srToUpdate = new ScaleRuleImpl(((AutoscaleProfileInner)this.inner()).rules().get(ruleIndex), this);
        return srToUpdate;
    }

    @Override
    public AutoscaleProfileImpl withoutScaleRule(int ruleIndex) {
        ((AutoscaleProfileInner)this.inner()).rules().remove(ruleIndex);
        return this;
    }

    AutoscaleProfileImpl addNewScaleRule(ScaleRuleImpl scaleRule) {
        ((AutoscaleProfileInner)this.inner()).rules().add((ScaleRuleInner)scaleRule.inner());
        return this;
    }
}

