/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerProbe;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.LoadDistribution;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.TransportProtocol;
import com.microsoft.azure.management.network.implementation.LoadBalancerBackendImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancerImpl;
import com.microsoft.azure.management.network.implementation.LoadBalancingRuleInner;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Arrays;
import java.util.Collection;

@LangDefinition
class LoadBalancingRuleImpl
extends ChildResourceImpl<LoadBalancingRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancingRule,
LoadBalancingRule.Definition<LoadBalancer.DefinitionStages.WithLBRuleOrNatOrCreate>,
LoadBalancingRule.UpdateDefinition<LoadBalancer.Update>,
LoadBalancingRule.Update {
    LoadBalancingRuleImpl(LoadBalancingRuleInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).name();
    }

    @Override
    public TransportProtocol protocol() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).protocol();
    }

    @Override
    public boolean floatingIPEnabled() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).enableFloatingIP();
    }

    @Override
    public int idleTimeoutInMinutes() {
        return Utils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.inner())).idleTimeoutInMinutes());
    }

    @Override
    public int frontendPort() {
        return Utils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.inner())).frontendPort());
    }

    @Override
    public int backendPort() {
        return Utils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.inner())).backendPort());
    }

    @Override
    public LoadDistribution loadDistribution() {
        return ((LoadBalancingRuleInner)((Object)this.inner())).loadDistribution();
    }

    @Override
    public LoadBalancerFrontend frontend() {
        SubResource frontendRef = ((LoadBalancingRuleInner)((Object)this.inner())).frontendIPConfiguration();
        if (frontendRef == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId((String)frontendRef.id());
        return ((LoadBalancerImpl)this.parent()).frontends().get(frontendName);
    }

    @Override
    public LoadBalancerBackend backend() {
        SubResource backendRef = ((LoadBalancingRuleInner)((Object)this.inner())).backendAddressPool();
        if (backendRef == null) {
            return null;
        }
        String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
        return ((LoadBalancerImpl)this.parent()).backends().get(backendName);
    }

    @Override
    public LoadBalancerProbe probe() {
        SubResource probeRef = ((LoadBalancingRuleInner)((Object)this.inner())).probe();
        if (probeRef == null) {
            return null;
        }
        String probeName = ResourceUtils.nameFromResourceId((String)probeRef.id());
        if (((LoadBalancerImpl)this.parent()).httpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).httpProbes().get(probeName);
        }
        if (((LoadBalancerImpl)this.parent()).tcpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).tcpProbes().get(probeName);
        }
        return null;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingPublicIPAddress(PublicIPAddress publicIPAddress) {
        return publicIPAddress != null ? this.fromExistingPublicIPAddress(publicIPAddress.id()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingPublicIPAddress(String resourceId) {
        return null != resourceId ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePublicFrontendWithPip(resourceId).name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress(String leafDnsLabel) {
        String frontendName = SdkContext.randomResourceName((String)"fe", (int)20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress(Creatable<PublicIPAddress> pipDefinition) {
        String frontendName = SdkContext.randomResourceName((String)"fe", (int)20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(pipDefinition, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress() {
        String dnsLabel = SdkContext.randomResourceName((String)"fe", (int)20);
        return this.fromNewPublicIPAddress(dnsLabel);
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(String networkResourceId, String subnetName) {
        return null != networkResourceId && null != subnetName ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePrivateFrontendWithSubnet(networkResourceId, subnetName).name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(Network network, String subnetName) {
        return null != network && null != subnetName ? this.fromExistingSubnet(network.id(), subnetName) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(Subnet subnet) {
        return null != subnet ? this.fromExistingSubnet(((Network)subnet.parent()).id(), subnet.name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIP(boolean enable) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withEnableFloatingIP(enable);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIPEnabled() {
        return this.withFloatingIP(true);
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIPDisabled() {
        return this.withFloatingIP(false);
    }

    @Override
    public LoadBalancingRuleImpl withProtocol(TransportProtocol protocol) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl fromFrontendPort(int port) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withFrontendPort(port);
        if (((LoadBalancingRuleInner)((Object)this.inner())).backendPort() == null || ((LoadBalancingRuleInner)((Object)this.inner())).backendPort() == 0) {
            ((LoadBalancingRuleInner)((Object)this.inner())).withBackendPort(port);
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl toBackendPort(int port) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withBackendPort(port);
        return this;
    }

    public LoadBalancingRuleImpl toExistingVirtualMachines(HasNetworkInterfaces ... vms) {
        return vms != null ? this.toExistingVirtualMachines(Arrays.asList(vms)) : this;
    }

    public LoadBalancingRuleImpl toExistingVirtualMachines(Collection<HasNetworkInterfaces> vms) {
        if (vms != null) {
            LoadBalancerBackend.DefinitionStages.WithAttach backend = ((LoadBalancerImpl)this.parent()).ensureUniqueBackend().withExistingVirtualMachines((Collection)vms);
            this.toBackend(((LoadBalancerBackendImpl)backend).name());
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withLoadDistribution(LoadDistribution loadDistribution) {
        ((LoadBalancingRuleInner)((Object)this.inner())).withLoadDistribution(loadDistribution);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl fromFrontend(String frontendName) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(frontendName);
        if (frontendRef != null) {
            ((LoadBalancingRuleInner)((Object)this.inner())).withFrontendIPConfiguration(frontendRef);
        }
        return this;
    }

    public LoadBalancingRuleImpl toBackend(String backendName) {
        ((LoadBalancerImpl)this.parent()).defineBackend(backendName).attach();
        SubResource backendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/backendAddressPools/" + backendName);
        ((LoadBalancingRuleInner)((Object)this.inner())).withBackendAddressPool(backendRef);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withProbe(String name) {
        SubResource probeRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/probes/" + name);
        ((LoadBalancingRuleInner)((Object)this.inner())).withProbe(probeRef);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withoutProbe() {
        ((LoadBalancingRuleInner)((Object)this.inner())).withProbe(null);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withLoadBalancingRule(this);
    }
}

