/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Route;
import com.microsoft.azure.management.network.RouteNextHopType;
import com.microsoft.azure.management.network.RouteTable;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.RouteImpl;
import com.microsoft.azure.management.network.implementation.RouteInner;
import com.microsoft.azure.management.network.implementation.RouteTableInner;
import com.microsoft.azure.management.network.model.GroupableParentResourceWithTagsImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class RouteTableImpl
extends GroupableParentResourceWithTagsImpl<RouteTable, RouteTableInner, RouteTableImpl, NetworkManager>
implements RouteTable,
RouteTable.Definition,
RouteTable.Update {
    private Map<String, Route> routes;

    RouteTableImpl(String name, RouteTableInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    protected Observable<RouteTableInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).routeTables().updateTagsAsync(this.resourceGroupName(), this.name(), ((RouteTableInner)((Object)this.inner())).getTags());
    }

    protected void initializeChildrenFromInner() {
        this.routes = new TreeMap<String, Route>();
        List<RouteInner> inners = ((RouteTableInner)((Object)this.inner())).routes();
        if (inners != null) {
            for (RouteInner inner : inners) {
                RouteImpl route = new RouteImpl(inner, this);
                this.routes.put(inner.name(), route);
            }
        }
    }

    public Observable<RouteTable> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<RouteTable, RouteTable>(){

            public RouteTable call(RouteTable routeTable) {
                RouteTableImpl impl = (RouteTableImpl)routeTable;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<RouteTableInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).routeTables().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public List<Subnet> listAssociatedSubnets() {
        return ((NetworkManager)this.myManager).listAssociatedSubnets(((RouteTableInner)((Object)this.inner())).subnets());
    }

    public RouteImpl defineRoute(String name) {
        RouteInner inner = new RouteInner().withName(name);
        return new RouteImpl(inner, this);
    }

    @Override
    public RouteImpl updateRoute(String name) {
        return (RouteImpl)this.routes.get(name);
    }

    @Override
    public RouteTable.Update withoutRoute(String name) {
        this.routes.remove(name);
        return this;
    }

    @Override
    public RouteTableImpl withRoute(String destinationAddressPrefix, RouteNextHopType nextHop) {
        return this.defineRoute("route_" + this.name() + System.currentTimeMillis()).withDestinationAddressPrefix(destinationAddressPrefix).withNextHop(nextHop).attach();
    }

    @Override
    public RouteTableImpl withRouteViaVirtualAppliance(String destinationAddressPrefix, String ipAddress) {
        return this.defineRoute("route_" + this.name() + System.currentTimeMillis()).withDestinationAddressPrefix(destinationAddressPrefix).withNextHopToVirtualAppliance(ipAddress).attach();
    }

    RouteTableImpl withRoute(RouteImpl route) {
        this.routes.put(route.name(), route);
        return this;
    }

    protected void beforeCreating() {
        ((RouteTableInner)((Object)this.inner())).withRoutes(this.innersFromWrappers(this.routes.values()));
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    protected Observable<RouteTableInner> createInner() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).routeTables().createOrUpdateAsync(this.resourceGroupName(), this.name(), (RouteTableInner)((Object)this.inner()));
    }

    @Override
    public Map<String, Route> routes() {
        return Collections.unmodifiableMap(this.routes);
    }

    @Override
    public boolean isBgpRoutePropagationDisabled() {
        return Utils.toPrimitiveBoolean((Boolean)((RouteTableInner)((Object)this.inner())).disableBgpRoutePropagation());
    }

    @Override
    public RouteTableImpl withDisableBgpRoutePropagation() {
        ((RouteTableInner)((Object)this.inner())).withDisableBgpRoutePropagation(true);
        return this;
    }

    @Override
    public RouteTableImpl withEnableBgpRoutePropagation() {
        ((RouteTableInner)((Object)this.inner())).withDisableBgpRoutePropagation(false);
        return this;
    }
}

