/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ApplicationGatewayOnDemandProbe;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayAvailableSslOptionsInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayAvailableWafRuleSetsResultInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHealthInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHealthOnDemandInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslPredefinedPolicyInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ApplicationGatewaysInner
implements InnerSupportsGet<ApplicationGatewayInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ApplicationGatewayInner> {
    private ApplicationGatewaysService service;
    private NetworkManagementClientImpl client;

    public ApplicationGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ApplicationGatewaysService)retrofit.create(ApplicationGatewaysService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String applicationGatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayInner getByResourceGroup(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> getByResourceGroupAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> getByResourceGroupAsync(String resourceGroupName, String applicationGatewayName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayInner createOrUpdate(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> createOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> createOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ApplicationGatewayInner>(){}.getType());
    }

    public ApplicationGatewayInner beginCreateOrUpdate(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationGatewayName, parameters).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayInner>(){}.getType()).register(201, new TypeToken<ApplicationGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayInner updateTags(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> updateTagsAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> updateTagsAsync(String resourceGroupName, String applicationGatewayName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ApplicationGatewayInner>(){}.getType());
    }

    public ApplicationGatewayInner updateTags(String resourceGroupName, String applicationGatewayName, Map<String, String> tags) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> updateTagsAsync(String resourceGroupName, String applicationGatewayName, Map<String, String> tags, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName, tags), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> updateTagsAsync(String resourceGroupName, String applicationGatewayName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName, tags).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ApplicationGatewayInner>(){}.getType());
    }

    public ApplicationGatewayInner beginUpdateTags(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationGatewayInner beginUpdateTags(String resourceGroupName, String applicationGatewayName, Map<String, String> tags) {
        return (ApplicationGatewayInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String applicationGatewayName, Map<String, String> tags, ServiceCallback<ApplicationGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName, tags), serviceCallback);
    }

    public Observable<ApplicationGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String applicationGatewayName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, applicationGatewayName, tags).map((Func1)new Func1<ServiceResponse<ApplicationGatewayInner>, ApplicationGatewayInner>(){

            public ApplicationGatewayInner call(ServiceResponse<ApplicationGatewayInner> response) {
                return (ApplicationGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.body()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationGatewayInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.body()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationGatewayInner>> listAsync(ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void start(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.startWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> startAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.startWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> startAsync(String resourceGroupName, String applicationGatewayName) {
        return this.startWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> startWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.start(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginStart(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.beginStartWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStartAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> beginStartAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginStartWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStartWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginStart(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginStartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStartDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void stop(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.stopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> stopAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.stopWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> stopAsync(String resourceGroupName, String applicationGatewayName) {
        return this.stopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> stopWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.stop(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginStop(String resourceGroupName, String applicationGatewayName) {
        ((ServiceResponse)this.beginStopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStopAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStopWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<Void> beginStopAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginStopWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStopWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginStop(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginStopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStopDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayBackendHealthInner backendHealth(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName) {
        return this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> backendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        String expand = null;
        Observable<Response<ResponseBody>> observable = this.service.backendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<ApplicationGatewayBackendHealthInner>(){}.getType());
    }

    public ApplicationGatewayBackendHealthInner backendHealth(String resourceGroupName, String applicationGatewayName, String expand) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).toBlocking().last()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> backendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        return this.backendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> backendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.backendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<ApplicationGatewayBackendHealthInner>(){}.getType());
    }

    public ApplicationGatewayBackendHealthInner beginBackendHealth(String resourceGroupName, String applicationGatewayName) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName) {
        return this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> beginBackendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        String expand = null;
        return this.service.beginBackendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginBackendHealthDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationGatewayBackendHealthInner beginBackendHealth(String resourceGroupName, String applicationGatewayName, String expand) {
        return (ApplicationGatewayBackendHealthInner)((ServiceResponse)this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand, ServiceCallback<ApplicationGatewayBackendHealthInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthInner> beginBackendHealthAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        return this.beginBackendHealthWithServiceResponseAsync(resourceGroupName, applicationGatewayName, expand).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthInner>, ApplicationGatewayBackendHealthInner>(){

            public ApplicationGatewayBackendHealthInner call(ServiceResponse<ApplicationGatewayBackendHealthInner> response) {
                return (ApplicationGatewayBackendHealthInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> beginBackendHealthWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginBackendHealth(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayBackendHealthInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginBackendHealthDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayBackendHealthInner> beginBackendHealthDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayBackendHealthInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayBackendHealthOnDemandInner backendHealthOnDemand(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest) {
        return (ApplicationGatewayBackendHealthOnDemandInner)((ServiceResponse)this.backendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest).toBlocking().last()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthOnDemandInner> backendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, ServiceCallback<ApplicationGatewayBackendHealthOnDemandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.backendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthOnDemandInner> backendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest) {
        return this.backendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>, ApplicationGatewayBackendHealthOnDemandInner>(){

            public ApplicationGatewayBackendHealthOnDemandInner call(ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner> response) {
                return (ApplicationGatewayBackendHealthOnDemandInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>> backendHealthOnDemandWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (probeRequest == null) {
            throw new IllegalArgumentException("Parameter probeRequest is required and cannot be null.");
        }
        Validator.validate((Object)probeRequest);
        String apiVersion = "2019-06-01";
        String expand = null;
        Observable<Response<ResponseBody>> observable = this.service.backendHealthOnDemand(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, probeRequest, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<ApplicationGatewayBackendHealthOnDemandInner>(){}.getType());
    }

    public ApplicationGatewayBackendHealthOnDemandInner backendHealthOnDemand(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand) {
        return (ApplicationGatewayBackendHealthOnDemandInner)((ServiceResponse)this.backendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest, expand).toBlocking().last()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthOnDemandInner> backendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand, ServiceCallback<ApplicationGatewayBackendHealthOnDemandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.backendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest, expand), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthOnDemandInner> backendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand) {
        return this.backendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest, expand).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>, ApplicationGatewayBackendHealthOnDemandInner>(){

            public ApplicationGatewayBackendHealthOnDemandInner call(ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner> response) {
                return (ApplicationGatewayBackendHealthOnDemandInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>> backendHealthOnDemandWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (probeRequest == null) {
            throw new IllegalArgumentException("Parameter probeRequest is required and cannot be null.");
        }
        Validator.validate((Object)probeRequest);
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.backendHealthOnDemand(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, probeRequest, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<ApplicationGatewayBackendHealthOnDemandInner>(){}.getType());
    }

    public ApplicationGatewayBackendHealthOnDemandInner beginBackendHealthOnDemand(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest) {
        return (ApplicationGatewayBackendHealthOnDemandInner)((ServiceResponse)this.beginBackendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthOnDemandInner> beginBackendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, ServiceCallback<ApplicationGatewayBackendHealthOnDemandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginBackendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthOnDemandInner> beginBackendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest) {
        return this.beginBackendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>, ApplicationGatewayBackendHealthOnDemandInner>(){

            public ApplicationGatewayBackendHealthOnDemandInner call(ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner> response) {
                return (ApplicationGatewayBackendHealthOnDemandInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>> beginBackendHealthOnDemandWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (probeRequest == null) {
            throw new IllegalArgumentException("Parameter probeRequest is required and cannot be null.");
        }
        Validator.validate((Object)probeRequest);
        String apiVersion = "2019-06-01";
        String expand = null;
        return this.service.beginBackendHealthOnDemand(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, probeRequest, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginBackendHealthOnDemandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationGatewayBackendHealthOnDemandInner beginBackendHealthOnDemand(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand) {
        return (ApplicationGatewayBackendHealthOnDemandInner)((ServiceResponse)this.beginBackendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest, expand).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationGatewayBackendHealthOnDemandInner> beginBackendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand, ServiceCallback<ApplicationGatewayBackendHealthOnDemandInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginBackendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest, expand), serviceCallback);
    }

    public Observable<ApplicationGatewayBackendHealthOnDemandInner> beginBackendHealthOnDemandAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand) {
        return this.beginBackendHealthOnDemandWithServiceResponseAsync(resourceGroupName, applicationGatewayName, probeRequest, expand).map((Func1)new Func1<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>, ApplicationGatewayBackendHealthOnDemandInner>(){

            public ApplicationGatewayBackendHealthOnDemandInner call(ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner> response) {
                return (ApplicationGatewayBackendHealthOnDemandInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>> beginBackendHealthOnDemandWithServiceResponseAsync(String resourceGroupName, String applicationGatewayName, ApplicationGatewayOnDemandProbe probeRequest, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationGatewayName == null) {
            throw new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (probeRequest == null) {
            throw new IllegalArgumentException("Parameter probeRequest is required and cannot be null.");
        }
        Validator.validate((Object)probeRequest);
        String apiVersion = "2019-06-01";
        return this.service.beginBackendHealthOnDemand(resourceGroupName, applicationGatewayName, this.client.subscriptionId(), "2019-06-01", expand, probeRequest, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.beginBackendHealthOnDemandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayBackendHealthOnDemandInner> beginBackendHealthOnDemandDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayBackendHealthOnDemandInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<String> listAvailableServerVariables() {
        return (List)((ServiceResponse)this.listAvailableServerVariablesWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<String>> listAvailableServerVariablesAsync(ServiceCallback<List<String>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableServerVariablesWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<String>> listAvailableServerVariablesAsync() {
        return this.listAvailableServerVariablesWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<String>>, List<String>>(){

            public List<String> call(ServiceResponse<List<String>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<String>>> listAvailableServerVariablesWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listAvailableServerVariables(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>(){

            public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.listAvailableServerVariablesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<String>> listAvailableServerVariablesDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<String>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public List<String> listAvailableRequestHeaders() {
        return (List)((ServiceResponse)this.listAvailableRequestHeadersWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<String>> listAvailableRequestHeadersAsync(ServiceCallback<List<String>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableRequestHeadersWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<String>> listAvailableRequestHeadersAsync() {
        return this.listAvailableRequestHeadersWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<String>>, List<String>>(){

            public List<String> call(ServiceResponse<List<String>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<String>>> listAvailableRequestHeadersWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listAvailableRequestHeaders(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>(){

            public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.listAvailableRequestHeadersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<String>> listAvailableRequestHeadersDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<String>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public List<String> listAvailableResponseHeaders() {
        return (List)((ServiceResponse)this.listAvailableResponseHeadersWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<String>> listAvailableResponseHeadersAsync(ServiceCallback<List<String>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableResponseHeadersWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<String>> listAvailableResponseHeadersAsync() {
        return this.listAvailableResponseHeadersWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<String>>, List<String>>(){

            public List<String> call(ServiceResponse<List<String>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<String>>> listAvailableResponseHeadersWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listAvailableResponseHeaders(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>(){

            public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.listAvailableResponseHeadersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<String>> listAvailableResponseHeadersDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<String>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public ApplicationGatewayAvailableWafRuleSetsResultInner listAvailableWafRuleSets() {
        return (ApplicationGatewayAvailableWafRuleSetsResultInner)((ServiceResponse)this.listAvailableWafRuleSetsWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationGatewayAvailableWafRuleSetsResultInner> listAvailableWafRuleSetsAsync(ServiceCallback<ApplicationGatewayAvailableWafRuleSetsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableWafRuleSetsWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<ApplicationGatewayAvailableWafRuleSetsResultInner> listAvailableWafRuleSetsAsync() {
        return this.listAvailableWafRuleSetsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<ApplicationGatewayAvailableWafRuleSetsResultInner>, ApplicationGatewayAvailableWafRuleSetsResultInner>(){

            public ApplicationGatewayAvailableWafRuleSetsResultInner call(ServiceResponse<ApplicationGatewayAvailableWafRuleSetsResultInner> response) {
                return (ApplicationGatewayAvailableWafRuleSetsResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayAvailableWafRuleSetsResultInner>> listAvailableWafRuleSetsWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listAvailableWafRuleSets(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayAvailableWafRuleSetsResultInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayAvailableWafRuleSetsResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.listAvailableWafRuleSetsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayAvailableWafRuleSetsResultInner> listAvailableWafRuleSetsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayAvailableWafRuleSetsResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewayAvailableSslOptionsInner listAvailableSslOptions() {
        return (ApplicationGatewayAvailableSslOptionsInner)((Object)((ServiceResponse)this.listAvailableSslOptionsWithServiceResponseAsync().toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationGatewayAvailableSslOptionsInner> listAvailableSslOptionsAsync(ServiceCallback<ApplicationGatewayAvailableSslOptionsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableSslOptionsWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<ApplicationGatewayAvailableSslOptionsInner> listAvailableSslOptionsAsync() {
        return this.listAvailableSslOptionsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<ApplicationGatewayAvailableSslOptionsInner>, ApplicationGatewayAvailableSslOptionsInner>(){

            public ApplicationGatewayAvailableSslOptionsInner call(ServiceResponse<ApplicationGatewayAvailableSslOptionsInner> response) {
                return (ApplicationGatewayAvailableSslOptionsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewayAvailableSslOptionsInner>> listAvailableSslOptionsWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listAvailableSslOptions(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewayAvailableSslOptionsInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewayAvailableSslOptionsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.listAvailableSslOptionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewayAvailableSslOptionsInner> listAvailableSslOptionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewayAvailableSslOptionsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewaySslPredefinedPolicyInner> listAvailableSslPredefinedPolicies() {
        ServiceResponse response = (ServiceResponse)this.listAvailableSslPredefinedPoliciesSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationGatewaySslPredefinedPolicyInner>((Page)response.body()){

            public Page<ApplicationGatewaySslPredefinedPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationGatewaySslPredefinedPolicyInner>> listAvailableSslPredefinedPoliciesAsync(ListOperationCallback<ApplicationGatewaySslPredefinedPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAvailableSslPredefinedPoliciesSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewaySslPredefinedPolicyInner>> listAvailableSslPredefinedPoliciesAsync() {
        return this.listAvailableSslPredefinedPoliciesWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>, Page<ApplicationGatewaySslPredefinedPolicyInner>>(){

            public Page<ApplicationGatewaySslPredefinedPolicyInner> call(ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> listAvailableSslPredefinedPoliciesWithServiceResponseAsync() {
        return this.listAvailableSslPredefinedPoliciesSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>, Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> call(ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> listAvailableSslPredefinedPoliciesSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listAvailableSslPredefinedPolicies(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewaySslPredefinedPolicyInner>> listAvailableSslPredefinedPoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewaySslPredefinedPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationGatewaySslPredefinedPolicyInner getSslPredefinedPolicy(String predefinedPolicyName) {
        return (ApplicationGatewaySslPredefinedPolicyInner)((Object)((ServiceResponse)this.getSslPredefinedPolicyWithServiceResponseAsync(predefinedPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationGatewaySslPredefinedPolicyInner> getSslPredefinedPolicyAsync(String predefinedPolicyName, ServiceCallback<ApplicationGatewaySslPredefinedPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSslPredefinedPolicyWithServiceResponseAsync(predefinedPolicyName), serviceCallback);
    }

    public Observable<ApplicationGatewaySslPredefinedPolicyInner> getSslPredefinedPolicyAsync(String predefinedPolicyName) {
        return this.getSslPredefinedPolicyWithServiceResponseAsync(predefinedPolicyName).map((Func1)new Func1<ServiceResponse<ApplicationGatewaySslPredefinedPolicyInner>, ApplicationGatewaySslPredefinedPolicyInner>(){

            public ApplicationGatewaySslPredefinedPolicyInner call(ServiceResponse<ApplicationGatewaySslPredefinedPolicyInner> response) {
                return (ApplicationGatewaySslPredefinedPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationGatewaySslPredefinedPolicyInner>> getSslPredefinedPolicyWithServiceResponseAsync(String predefinedPolicyName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (predefinedPolicyName == null) {
            throw new IllegalArgumentException("Parameter predefinedPolicyName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getSslPredefinedPolicy(this.client.subscriptionId(), predefinedPolicyName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationGatewaySslPredefinedPolicyInner>>>(){

            public Observable<ServiceResponse<ApplicationGatewaySslPredefinedPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationGatewaysInner.this.getSslPredefinedPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationGatewaySslPredefinedPolicyInner> getSslPredefinedPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationGatewaySslPredefinedPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.body()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationGatewayInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ApplicationGatewayInner>> serviceFuture, ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewayInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationGatewayInner>((Page)response.body()){

            public Page<ApplicationGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationGatewayInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationGatewayInner>> serviceFuture, ListOperationCallback<ApplicationGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewayInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Page<ApplicationGatewayInner>>(){

            public Page<ApplicationGatewayInner> call(ServiceResponse<Page<ApplicationGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewayInner>>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(ServiceResponse<Page<ApplicationGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationGatewaySslPredefinedPolicyInner> listAvailableSslPredefinedPoliciesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationGatewaySslPredefinedPolicyInner>((Page)response.body()){

            public Page<ApplicationGatewaySslPredefinedPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationGatewaySslPredefinedPolicyInner>> listAvailableSslPredefinedPoliciesNextAsync(String nextPageLink, ServiceFuture<List<ApplicationGatewaySslPredefinedPolicyInner>> serviceFuture, ListOperationCallback<ApplicationGatewaySslPredefinedPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> call(String nextPageLink) {
                return ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationGatewaySslPredefinedPolicyInner>> listAvailableSslPredefinedPoliciesNextAsync(String nextPageLink) {
        return this.listAvailableSslPredefinedPoliciesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>, Page<ApplicationGatewaySslPredefinedPolicyInner>>(){

            public Page<ApplicationGatewaySslPredefinedPolicyInner> call(ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> listAvailableSslPredefinedPoliciesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAvailableSslPredefinedPoliciesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>, Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> call(ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> listAvailableSslPredefinedPoliciesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAvailableSslPredefinedPoliciesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationGatewaySslPredefinedPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationGatewaysInner.this.listAvailableSslPredefinedPoliciesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationGatewaySslPredefinedPolicyInner>> listAvailableSslPredefinedPoliciesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationGatewaySslPredefinedPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ApplicationGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body ApplicationGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body ApplicationGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways start"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/start")
        public Observable<Response<ResponseBody>> start(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginStart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/start")
        public Observable<Response<ResponseBody>> beginStart(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways stop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/stop")
        public Observable<Response<ResponseBody>> stop(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginStop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/stop")
        public Observable<Response<ResponseBody>> beginStop(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways backendHealth"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendhealth")
        public Observable<Response<ResponseBody>> backendHealth(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginBackendHealth"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendhealth")
        public Observable<Response<ResponseBody>> beginBackendHealth(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways backendHealthOnDemand"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/getBackendHealthOnDemand")
        public Observable<Response<ResponseBody>> backendHealthOnDemand(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Body ApplicationGatewayOnDemandProbe var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways beginBackendHealthOnDemand"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/getBackendHealthOnDemand")
        public Observable<Response<ResponseBody>> beginBackendHealthOnDemand(@Path(value="resourceGroupName") String var1, @Path(value="applicationGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Body ApplicationGatewayOnDemandProbe var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableServerVariables"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableServerVariables")
        public Observable<Response<ResponseBody>> listAvailableServerVariables(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableRequestHeaders"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableRequestHeaders")
        public Observable<Response<ResponseBody>> listAvailableRequestHeaders(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableResponseHeaders"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableResponseHeaders")
        public Observable<Response<ResponseBody>> listAvailableResponseHeaders(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableWafRuleSets"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableWafRuleSets")
        public Observable<Response<ResponseBody>> listAvailableWafRuleSets(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableSslOptions"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableSslOptions/default")
        public Observable<Response<ResponseBody>> listAvailableSslOptions(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableSslPredefinedPolicies"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableSslOptions/default/predefinedPolicies")
        public Observable<Response<ResponseBody>> listAvailableSslPredefinedPolicies(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways getSslPredefinedPolicy"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableSslOptions/default/predefinedPolicies/{predefinedPolicyName}")
        public Observable<Response<ResponseBody>> getSslPredefinedPolicy(@Path(value="subscriptionId") String var1, @Path(value="predefinedPolicyName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationGateways listAvailableSslPredefinedPoliciesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAvailableSslPredefinedPoliciesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

