/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.AvailablePrivateEndpointTypeInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AvailablePrivateEndpointTypesInner {
    private AvailablePrivateEndpointTypesService service;
    private NetworkManagementClientImpl client;

    public AvailablePrivateEndpointTypesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (AvailablePrivateEndpointTypesService)retrofit.create(AvailablePrivateEndpointTypesService.class);
        this.client = client;
    }

    public PagedList<AvailablePrivateEndpointTypeInner> list(String location) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(location).toBlocking().single();
        return new PagedList<AvailablePrivateEndpointTypeInner>((Page)response.body()){

            public Page<AvailablePrivateEndpointTypeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailablePrivateEndpointTypesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailablePrivateEndpointTypeInner>> listAsync(String location, ListOperationCallback<AvailablePrivateEndpointTypeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(String nextPageLink) {
                return AvailablePrivateEndpointTypesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailablePrivateEndpointTypeInner>> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Page<AvailablePrivateEndpointTypeInner>>(){

            public Page<AvailablePrivateEndpointTypeInner> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listWithServiceResponseAsync(String location) {
        return this.listSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailablePrivateEndpointTypesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(location, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailablePrivateEndpointTypesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailablePrivateEndpointTypeInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailablePrivateEndpointTypeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailablePrivateEndpointTypeInner> listByResourceGroup(String location, String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(location, resourceGroupName).toBlocking().single();
        return new PagedList<AvailablePrivateEndpointTypeInner>((Page)response.body()){

            public Page<AvailablePrivateEndpointTypeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailablePrivateEndpointTypeInner>> listByResourceGroupAsync(String location, String resourceGroupName, ListOperationCallback<AvailablePrivateEndpointTypeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(location, resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(String nextPageLink) {
                return AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailablePrivateEndpointTypeInner>> listByResourceGroupAsync(String location, String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(location, resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Page<AvailablePrivateEndpointTypeInner>>(){

            public Page<AvailablePrivateEndpointTypeInner> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listByResourceGroupWithServiceResponseAsync(String location, String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(location, resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listByResourceGroupSinglePageAsync(String location, String resourceGroupName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailablePrivateEndpointTypesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailablePrivateEndpointTypeInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailablePrivateEndpointTypeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailablePrivateEndpointTypeInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AvailablePrivateEndpointTypeInner>((Page)response.body()){

            public Page<AvailablePrivateEndpointTypeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailablePrivateEndpointTypesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailablePrivateEndpointTypeInner>> listNextAsync(String nextPageLink, ServiceFuture<List<AvailablePrivateEndpointTypeInner>> serviceFuture, ListOperationCallback<AvailablePrivateEndpointTypeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(String nextPageLink) {
                return AvailablePrivateEndpointTypesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailablePrivateEndpointTypeInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Page<AvailablePrivateEndpointTypeInner>>(){

            public Page<AvailablePrivateEndpointTypeInner> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailablePrivateEndpointTypesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailablePrivateEndpointTypesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailablePrivateEndpointTypeInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailablePrivateEndpointTypeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailablePrivateEndpointTypeInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AvailablePrivateEndpointTypeInner>((Page)response.body()){

            public Page<AvailablePrivateEndpointTypeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailablePrivateEndpointTypeInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<AvailablePrivateEndpointTypeInner>> serviceFuture, ListOperationCallback<AvailablePrivateEndpointTypeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(String nextPageLink) {
                return AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailablePrivateEndpointTypeInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Page<AvailablePrivateEndpointTypeInner>>(){

            public Page<AvailablePrivateEndpointTypeInner> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(ServiceResponse<Page<AvailablePrivateEndpointTypeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>>>(){

            public Observable<ServiceResponse<Page<AvailablePrivateEndpointTypeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailablePrivateEndpointTypesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailablePrivateEndpointTypeInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailablePrivateEndpointTypeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AvailablePrivateEndpointTypesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailablePrivateEndpointTypes list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/availablePrivateEndpointTypes")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailablePrivateEndpointTypes listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/locations/{location}/availablePrivateEndpointTypes")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="location") String var1, @Path(value="resourceGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailablePrivateEndpointTypes listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailablePrivateEndpointTypes listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

