/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.DdosCustomPolicyInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DdosCustomPoliciesInner
implements InnerSupportsGet<DdosCustomPolicyInner>,
InnerSupportsDelete<Void> {
    private DdosCustomPoliciesService service;
    private NetworkManagementClientImpl client;

    public DdosCustomPoliciesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (DdosCustomPoliciesService)retrofit.create(DdosCustomPoliciesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String ddosCustomPolicyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ddosCustomPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String ddosCustomPolicyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String ddosCustomPolicyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String ddosCustomPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String ddosCustomPolicyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosCustomPoliciesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DdosCustomPolicyInner getByResourceGroup(String resourceGroupName, String ddosCustomPolicyName) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> getByResourceGroupAsync(String resourceGroupName, String ddosCustomPolicyName, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> getByResourceGroupAsync(String resourceGroupName, String ddosCustomPolicyName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosCustomPolicyInner>>>(){

            public Observable<ServiceResponse<DdosCustomPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosCustomPoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DdosCustomPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DdosCustomPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DdosCustomPolicyInner createOrUpdate(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> createOrUpdateAsync(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, parameters), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> createOrUpdateAsync(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, parameters).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DdosCustomPolicyInner>(){}.getType());
    }

    public DdosCustomPolicyInner beginCreateOrUpdate(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, parameters), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, parameters).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName, DdosCustomPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosCustomPolicyInner>>>(){

            public Observable<ServiceResponse<DdosCustomPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosCustomPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DdosCustomPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DdosCustomPolicyInner>(){}.getType()).register(201, new TypeToken<DdosCustomPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DdosCustomPolicyInner updateTags(String resourceGroupName, String ddosCustomPolicyName) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).toBlocking().last()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> updateTagsAsync(String resourceGroupName, String ddosCustomPolicyName, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> updateTagsAsync(String resourceGroupName, String ddosCustomPolicyName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DdosCustomPolicyInner>(){}.getType());
    }

    public DdosCustomPolicyInner updateTags(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> updateTagsAsync(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, tags), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> updateTagsAsync(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, tags).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DdosCustomPolicyInner>(){}.getType());
    }

    public DdosCustomPolicyInner beginUpdateTags(String resourceGroupName, String ddosCustomPolicyName) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> beginUpdateTagsAsync(String resourceGroupName, String ddosCustomPolicyName, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> beginUpdateTagsAsync(String resourceGroupName, String ddosCustomPolicyName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosCustomPolicyInner>>>(){

            public Observable<ServiceResponse<DdosCustomPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosCustomPoliciesInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DdosCustomPolicyInner beginUpdateTags(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags) {
        return (DdosCustomPolicyInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<DdosCustomPolicyInner> beginUpdateTagsAsync(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags, ServiceCallback<DdosCustomPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, tags), serviceCallback);
    }

    public Observable<DdosCustomPolicyInner> beginUpdateTagsAsync(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, ddosCustomPolicyName, tags).map((Func1)new Func1<ServiceResponse<DdosCustomPolicyInner>, DdosCustomPolicyInner>(){

            public DdosCustomPolicyInner call(ServiceResponse<DdosCustomPolicyInner> response) {
                return (DdosCustomPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DdosCustomPolicyInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String ddosCustomPolicyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ddosCustomPolicyName == null) {
            throw new IllegalArgumentException("Parameter ddosCustomPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, ddosCustomPolicyName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DdosCustomPolicyInner>>>(){

            public Observable<ServiceResponse<DdosCustomPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DdosCustomPoliciesInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DdosCustomPolicyInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DdosCustomPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DdosCustomPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Body DdosCustomPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Body DdosCustomPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.DdosCustomPolicies beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosCustomPolicies/{ddosCustomPolicyName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="ddosCustomPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);
    }
}

