/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkProfileInner;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class NetworkProfilesInner
implements InnerSupportsGet<NetworkProfileInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<NetworkProfileInner> {
    private NetworkProfilesService service;
    private NetworkManagementClientImpl client;

    public NetworkProfilesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (NetworkProfilesService)retrofit.create(NetworkProfilesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String networkProfileName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, networkProfileName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkProfileName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, networkProfileName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String networkProfileName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, networkProfileName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkProfileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, networkProfileName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String networkProfileName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkProfileName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkProfileName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkProfileName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkProfileName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkProfileName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkProfileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, networkProfileName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkProfilesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkProfileInner getByResourceGroup(String resourceGroupName, String networkProfileName) {
        return (NetworkProfileInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkProfileName).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkProfileInner> getByResourceGroupAsync(String resourceGroupName, String networkProfileName, ServiceCallback<NetworkProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkProfileName), serviceCallback);
    }

    public Observable<NetworkProfileInner> getByResourceGroupAsync(String resourceGroupName, String networkProfileName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkProfileName).map((Func1)new Func1<ServiceResponse<NetworkProfileInner>, NetworkProfileInner>(){

            public NetworkProfileInner call(ServiceResponse<NetworkProfileInner> response) {
                return (NetworkProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkProfileInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String networkProfileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, networkProfileName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkProfileInner>>>(){

            public Observable<ServiceResponse<NetworkProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkProfilesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public NetworkProfileInner getByResourceGroup(String resourceGroupName, String networkProfileName, String expand) {
        return (NetworkProfileInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkProfileName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkProfileInner> getByResourceGroupAsync(String resourceGroupName, String networkProfileName, String expand, ServiceCallback<NetworkProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkProfileName, expand), serviceCallback);
    }

    public Observable<NetworkProfileInner> getByResourceGroupAsync(String resourceGroupName, String networkProfileName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, networkProfileName, expand).map((Func1)new Func1<ServiceResponse<NetworkProfileInner>, NetworkProfileInner>(){

            public NetworkProfileInner call(ServiceResponse<NetworkProfileInner> response) {
                return (NetworkProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkProfileInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String networkProfileName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, networkProfileName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkProfileInner>>>(){

            public Observable<ServiceResponse<NetworkProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NetworkProfilesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkProfileInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NetworkProfileInner createOrUpdate(String resourceGroupName, String networkProfileName, NetworkProfileInner parameters) {
        return (NetworkProfileInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkProfileName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<NetworkProfileInner> createOrUpdateAsync(String resourceGroupName, String networkProfileName, NetworkProfileInner parameters, ServiceCallback<NetworkProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkProfileName, parameters), serviceCallback);
    }

    public Observable<NetworkProfileInner> createOrUpdateAsync(String resourceGroupName, String networkProfileName, NetworkProfileInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, networkProfileName, parameters).map((Func1)new Func1<ServiceResponse<NetworkProfileInner>, NetworkProfileInner>(){

            public NetworkProfileInner call(ServiceResponse<NetworkProfileInner> response) {
                return (NetworkProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkProfileInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String networkProfileName, NetworkProfileInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, networkProfileName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<NetworkProfileInner>(){}.getType());
    }

    public NetworkProfileInner updateTags(String resourceGroupName, String networkProfileName) {
        return (NetworkProfileInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, networkProfileName).toBlocking().last()).body());
    }

    public ServiceFuture<NetworkProfileInner> updateTagsAsync(String resourceGroupName, String networkProfileName, ServiceCallback<NetworkProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, networkProfileName), serviceCallback);
    }

    public Observable<NetworkProfileInner> updateTagsAsync(String resourceGroupName, String networkProfileName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, networkProfileName).map((Func1)new Func1<ServiceResponse<NetworkProfileInner>, NetworkProfileInner>(){

            public NetworkProfileInner call(ServiceResponse<NetworkProfileInner> response) {
                return (NetworkProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkProfileInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String networkProfileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, networkProfileName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<NetworkProfileInner>(){}.getType());
    }

    public NetworkProfileInner updateTags(String resourceGroupName, String networkProfileName, Map<String, String> tags) {
        return (NetworkProfileInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, networkProfileName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<NetworkProfileInner> updateTagsAsync(String resourceGroupName, String networkProfileName, Map<String, String> tags, ServiceCallback<NetworkProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, networkProfileName, tags), serviceCallback);
    }

    public Observable<NetworkProfileInner> updateTagsAsync(String resourceGroupName, String networkProfileName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, networkProfileName, tags).map((Func1)new Func1<ServiceResponse<NetworkProfileInner>, NetworkProfileInner>(){

            public NetworkProfileInner call(ServiceResponse<NetworkProfileInner> response) {
                return (NetworkProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkProfileInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String networkProfileName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkProfileName == null) {
            throw new IllegalArgumentException("Parameter networkProfileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, networkProfileName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<NetworkProfileInner>(){}.getType());
    }

    public PagedList<NetworkProfileInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<NetworkProfileInner>((Page)response.body()){

            public Page<NetworkProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkProfilesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkProfileInner>> listAsync(ListOperationCallback<NetworkProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(String nextPageLink) {
                return NetworkProfilesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkProfileInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Page<NetworkProfileInner>>(){

            public Page<NetworkProfileInner> call(ServiceResponse<Page<NetworkProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(ServiceResponse<Page<NetworkProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkProfilesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkProfilesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkProfileInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkProfileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkProfileInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<NetworkProfileInner>((Page)response.body()){

            public Page<NetworkProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkProfileInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<NetworkProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(String nextPageLink) {
                return NetworkProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkProfileInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Page<NetworkProfileInner>>(){

            public Page<NetworkProfileInner> call(ServiceResponse<Page<NetworkProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(ServiceResponse<Page<NetworkProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkProfilesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkProfilesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkProfileInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkProfileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkProfileInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NetworkProfileInner>((Page)response.body()){

            public Page<NetworkProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkProfilesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkProfileInner>> listNextAsync(String nextPageLink, ServiceFuture<List<NetworkProfileInner>> serviceFuture, ListOperationCallback<NetworkProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(String nextPageLink) {
                return NetworkProfilesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkProfileInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Page<NetworkProfileInner>>(){

            public Page<NetworkProfileInner> call(ServiceResponse<Page<NetworkProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(ServiceResponse<Page<NetworkProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkProfilesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkProfilesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkProfileInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkProfileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NetworkProfileInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NetworkProfileInner>((Page)response.body()){

            public Page<NetworkProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NetworkProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NetworkProfileInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<NetworkProfileInner>> serviceFuture, ListOperationCallback<NetworkProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(String nextPageLink) {
                return NetworkProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NetworkProfileInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Page<NetworkProfileInner>>(){

            public Page<NetworkProfileInner> call(ServiceResponse<Page<NetworkProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NetworkProfileInner>>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(ServiceResponse<Page<NetworkProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NetworkProfilesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NetworkProfileInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NetworkProfileInner>>>>(){

            public Observable<ServiceResponse<Page<NetworkProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NetworkProfilesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NetworkProfileInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NetworkProfileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NetworkProfilesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="networkProfileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="networkProfileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="networkProfileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="networkProfileName") String var2, @Path(value="subscriptionId") String var3, @Body NetworkProfileInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="networkProfileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/networkProfiles")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NetworkProfiles listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

