/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.AuthenticationMethod;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.P2SVpnProfileParameters;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.P2SVpnGatewayInner;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnProfileResponseInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class P2sVpnGatewaysInner
implements InnerSupportsGet<P2SVpnGatewayInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<P2SVpnGatewayInner> {
    private P2sVpnGatewaysService service;
    private NetworkManagementClientImpl client;

    public P2sVpnGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (P2sVpnGatewaysService)retrofit.create(P2sVpnGatewaysService.class);
        this.client = client;
    }

    public P2SVpnGatewayInner getByResourceGroup(String resourceGroupName, String gatewayName) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> getByResourceGroupAsync(String resourceGroupName, String gatewayName, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> getByResourceGroupAsync(String resourceGroupName, String gatewayName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>(){

            public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<P2SVpnGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<P2SVpnGatewayInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public P2SVpnGatewayInner createOrUpdate(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).toBlocking().last()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> createOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (p2SVpnGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnGatewayParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)p2SVpnGatewayParameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", p2SVpnGatewayParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<P2SVpnGatewayInner>(){}.getType());
    }

    public P2SVpnGatewayInner beginCreateOrUpdate(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, gatewayName, p2SVpnGatewayParameters).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String gatewayName, P2SVpnGatewayInner p2SVpnGatewayParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (p2SVpnGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnGatewayParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)p2SVpnGatewayParameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", p2SVpnGatewayParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>(){

            public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<P2SVpnGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<P2SVpnGatewayInner>(){}.getType()).register(201, new TypeToken<P2SVpnGatewayInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public P2SVpnGatewayInner updateTags(String resourceGroupName, String gatewayName) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject p2SVpnGatewayParameters = new TagsObject();
        p2SVpnGatewayParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), p2SVpnGatewayParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<P2SVpnGatewayInner>(){}.getType());
    }

    public P2SVpnGatewayInner updateTags(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> updateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject p2SVpnGatewayParameters = new TagsObject();
        p2SVpnGatewayParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), p2SVpnGatewayParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<P2SVpnGatewayInner>(){}.getType());
    }

    public P2SVpnGatewayInner beginUpdateTags(String resourceGroupName, String gatewayName) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String gatewayName, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String gatewayName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject p2SVpnGatewayParameters = new TagsObject();
        p2SVpnGatewayParameters.withTags(null);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), p2SVpnGatewayParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>(){

            public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public P2SVpnGatewayInner beginUpdateTags(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, gatewayName, tags).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String gatewayName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject p2SVpnGatewayParameters = new TagsObject();
        p2SVpnGatewayParameters.withTags(tags);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), p2SVpnGatewayParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>(){

            public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<P2SVpnGatewayInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<P2SVpnGatewayInner>(){}.getType()).register(201, new TypeToken<P2SVpnGatewayInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String gatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String gatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String gatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String gatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String gatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String gatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, gatewayName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<P2SVpnGatewayInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>((Page)response.body()){

            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)P2sVpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<P2SVpnGatewayInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                return P2sVpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<P2SVpnGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>(){

            public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(P2sVpnGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = P2sVpnGatewaysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<P2SVpnGatewayInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>((Page)response.body()){

            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)P2sVpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<P2SVpnGatewayInner>> listAsync(ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                return P2sVpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<P2SVpnGatewayInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>(){

            public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(P2sVpnGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = P2sVpnGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VpnProfileResponseInner generateVpnProfile(String resourceGroupName, String gatewayName) {
        return (VpnProfileResponseInner)((ServiceResponse)this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName, ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName) {
        return this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>(){

            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return (VpnProfileResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnProfileResponseInner>> generateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object authenticationMethod = null;
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(null);
        Observable<Response<ResponseBody>> observable = this.service.generateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnProfileResponseInner>(){}.getType());
    }

    public VpnProfileResponseInner generateVpnProfile(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return (VpnProfileResponseInner)((ServiceResponse)this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).toBlocking().last()).body();
    }

    public ServiceFuture<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod, ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod), serviceCallback);
    }

    public Observable<VpnProfileResponseInner> generateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).map((Func1)new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>(){

            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return (VpnProfileResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnProfileResponseInner>> generateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(authenticationMethod);
        Observable<Response<ResponseBody>> observable = this.service.generateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnProfileResponseInner>(){}.getType());
    }

    public VpnProfileResponseInner beginGenerateVpnProfile(String resourceGroupName, String gatewayName) {
        return (VpnProfileResponseInner)((ServiceResponse)this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName, ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName) {
        return this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>(){

            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return (VpnProfileResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnProfileResponseInner>> beginGenerateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object authenticationMethod = null;
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(null);
        return this.service.beginGenerateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnProfileResponseInner>>>(){

            public Observable<ServiceResponse<VpnProfileResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginGenerateVpnProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VpnProfileResponseInner beginGenerateVpnProfile(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return (VpnProfileResponseInner)((ServiceResponse)this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).toBlocking().single()).body();
    }

    public ServiceFuture<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod, ServiceCallback<VpnProfileResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod), serviceCallback);
    }

    public Observable<VpnProfileResponseInner> beginGenerateVpnProfileAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        return this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, gatewayName, authenticationMethod).map((Func1)new Func1<ServiceResponse<VpnProfileResponseInner>, VpnProfileResponseInner>(){

            public VpnProfileResponseInner call(ServiceResponse<VpnProfileResponseInner> response) {
                return (VpnProfileResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnProfileResponseInner>> beginGenerateVpnProfileWithServiceResponseAsync(String resourceGroupName, String gatewayName, AuthenticationMethod authenticationMethod) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        P2SVpnProfileParameters parameters = new P2SVpnProfileParameters();
        parameters.withAuthenticationMethod(authenticationMethod);
        return this.service.beginGenerateVpnProfile(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnProfileResponseInner>>>(){

            public Observable<ServiceResponse<VpnProfileResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginGenerateVpnProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnProfileResponseInner> beginGenerateVpnProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnProfileResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public P2SVpnGatewayInner getP2sVpnConnectionHealth(String resourceGroupName, String gatewayName) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.getP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().last()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> getP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> getP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName) {
        return this.getP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> getP2sVpnConnectionHealthWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getP2sVpnConnectionHealth(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<P2SVpnGatewayInner>(){}.getType());
    }

    public P2SVpnGatewayInner beginGetP2sVpnConnectionHealth(String resourceGroupName, String gatewayName) {
        return (P2SVpnGatewayInner)((Object)((ServiceResponse)this.beginGetP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnGatewayInner> beginGetP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName, ServiceCallback<P2SVpnGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName), serviceCallback);
    }

    public Observable<P2SVpnGatewayInner> beginGetP2sVpnConnectionHealthAsync(String resourceGroupName, String gatewayName) {
        return this.beginGetP2sVpnConnectionHealthWithServiceResponseAsync(resourceGroupName, gatewayName).map((Func1)new Func1<ServiceResponse<P2SVpnGatewayInner>, P2SVpnGatewayInner>(){

            public P2SVpnGatewayInner call(ServiceResponse<P2SVpnGatewayInner> response) {
                return (P2SVpnGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnGatewayInner>> beginGetP2sVpnConnectionHealthWithServiceResponseAsync(String resourceGroupName, String gatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginGetP2sVpnConnectionHealth(resourceGroupName, gatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnGatewayInner>>>(){

            public Observable<ServiceResponse<P2SVpnGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnGatewaysInner.this.beginGetP2sVpnConnectionHealthDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<P2SVpnGatewayInner> beginGetP2sVpnConnectionHealthDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<P2SVpnGatewayInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<P2SVpnGatewayInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>((Page)response.body()){

            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)P2sVpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<P2SVpnGatewayInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<P2SVpnGatewayInner>> serviceFuture, ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                return P2sVpnGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<P2SVpnGatewayInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>(){

            public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(P2sVpnGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = P2sVpnGatewaysInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<P2SVpnGatewayInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<P2SVpnGatewayInner>((Page)response.body()){

            public Page<P2SVpnGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)P2sVpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<P2SVpnGatewayInner>> listNextAsync(String nextPageLink, ServiceFuture<List<P2SVpnGatewayInner>> serviceFuture, ListOperationCallback<P2SVpnGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(String nextPageLink) {
                return P2sVpnGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<P2SVpnGatewayInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Page<P2SVpnGatewayInner>>(){

            public Page<P2SVpnGatewayInner> call(ServiceResponse<Page<P2SVpnGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<P2SVpnGatewayInner>>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(ServiceResponse<Page<P2SVpnGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(P2sVpnGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = P2sVpnGatewaysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<P2SVpnGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<P2SVpnGatewayInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface P2sVpnGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Body P2SVpnGatewayInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Body P2SVpnGatewayInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/p2svpnGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways generateVpnProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/generatevpnprofile")
        public Observable<Response<ResponseBody>> generateVpnProfile(@Path(value="resourceGroupName") String var1, @Path(value="gatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body P2SVpnProfileParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginGenerateVpnProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/generatevpnprofile")
        public Observable<Response<ResponseBody>> beginGenerateVpnProfile(@Path(value="resourceGroupName") String var1, @Path(value="gatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body P2SVpnProfileParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways getP2sVpnConnectionHealth"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/getP2sVpnConnectionHealth")
        public Observable<Response<ResponseBody>> getP2sVpnConnectionHealth(@Path(value="resourceGroupName") String var1, @Path(value="gatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways beginGetP2sVpnConnectionHealth"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}/getP2sVpnConnectionHealth")
        public Observable<Response<ResponseBody>> beginGetP2sVpnConnectionHealth(@Path(value="resourceGroupName") String var1, @Path(value="gatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnGateways listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

