/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.management.network.ErrorResponseException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PacketCaptureInner;
import com.microsoft.azure.management.network.implementation.PacketCaptureQueryStatusResultInner;
import com.microsoft.azure.management.network.implementation.PacketCaptureResultInner;
import com.microsoft.azure.management.network.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PacketCapturesInner {
    private PacketCapturesService service;
    private NetworkManagementClientImpl client;

    public PacketCapturesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PacketCapturesService)retrofit.create(PacketCapturesService.class);
        this.client = client;
    }

    public PacketCaptureResultInner create(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return (PacketCaptureResultInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<PacketCaptureResultInner> createAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters, ServiceCallback<PacketCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters), serviceCallback);
    }

    public Observable<PacketCaptureResultInner> createAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).map((Func1)new Func1<ServiceResponse<PacketCaptureResultInner>, PacketCaptureResultInner>(){

            public PacketCaptureResultInner call(ServiceResponse<PacketCaptureResultInner> response) {
                return (PacketCaptureResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PacketCaptureResultInner>> createWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PacketCaptureResultInner>(){}.getType());
    }

    public PacketCaptureResultInner beginCreate(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return (PacketCaptureResultInner)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PacketCaptureResultInner> beginCreateAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters, ServiceCallback<PacketCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters), serviceCallback);
    }

    public Observable<PacketCaptureResultInner> beginCreateAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName, parameters).map((Func1)new Func1<ServiceResponse<PacketCaptureResultInner>, PacketCaptureResultInner>(){

            public PacketCaptureResultInner call(ServiceResponse<PacketCaptureResultInner> response) {
                return (PacketCaptureResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PacketCaptureResultInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, PacketCaptureInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2019-06-01";
        return this.service.beginCreate(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PacketCaptureResultInner>>>(){

            public Observable<ServiceResponse<PacketCaptureResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PacketCapturesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PacketCaptureResultInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<PacketCaptureResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PacketCaptureResultInner get(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return (PacketCaptureResultInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single()).body();
    }

    public ServiceFuture<PacketCaptureResultInner> getAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<PacketCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<PacketCaptureResultInner> getAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.getWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<PacketCaptureResultInner>, PacketCaptureResultInner>(){

            public PacketCaptureResultInner call(ServiceResponse<PacketCaptureResultInner> response) {
                return (PacketCaptureResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PacketCaptureResultInner>> getWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PacketCaptureResultInner>>>(){

            public Observable<ServiceResponse<PacketCaptureResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PacketCapturesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PacketCaptureResultInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PacketCaptureResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PacketCapturesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void stop(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        ((ServiceResponse)this.stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> stopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<Void> stopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.stopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> stopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.stop(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginStop(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        ((ServiceResponse)this.beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<Void> beginStopAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.beginStopWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStopWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginStop(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PacketCapturesInner.this.beginStopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStopDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PacketCaptureQueryStatusResultInner getStatus(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return (PacketCaptureQueryStatusResultInner)((ServiceResponse)this.getStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().last()).body();
    }

    public ServiceFuture<PacketCaptureQueryStatusResultInner> getStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<PacketCaptureQueryStatusResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<PacketCaptureQueryStatusResultInner> getStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.getStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner>(){

            public PacketCaptureQueryStatusResultInner call(ServiceResponse<PacketCaptureQueryStatusResultInner> response) {
                return (PacketCaptureQueryStatusResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>> getStatusWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getStatus(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<PacketCaptureQueryStatusResultInner>(){}.getType());
    }

    public PacketCaptureQueryStatusResultInner beginGetStatus(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return (PacketCaptureQueryStatusResultInner)((ServiceResponse)this.beginGetStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).toBlocking().single()).body();
    }

    public ServiceFuture<PacketCaptureQueryStatusResultInner> beginGetStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName, ServiceCallback<PacketCaptureQueryStatusResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName), serviceCallback);
    }

    public Observable<PacketCaptureQueryStatusResultInner> beginGetStatusAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        return this.beginGetStatusWithServiceResponseAsync(resourceGroupName, networkWatcherName, packetCaptureName).map((Func1)new Func1<ServiceResponse<PacketCaptureQueryStatusResultInner>, PacketCaptureQueryStatusResultInner>(){

            public PacketCaptureQueryStatusResultInner call(ServiceResponse<PacketCaptureQueryStatusResultInner> response) {
                return (PacketCaptureQueryStatusResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>> beginGetStatusWithServiceResponseAsync(String resourceGroupName, String networkWatcherName, String packetCaptureName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (packetCaptureName == null) {
            throw new IllegalArgumentException("Parameter packetCaptureName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginGetStatus(resourceGroupName, networkWatcherName, packetCaptureName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>>>(){

            public Observable<ServiceResponse<PacketCaptureQueryStatusResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PacketCapturesInner.this.beginGetStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PacketCaptureQueryStatusResultInner> beginGetStatusDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PacketCaptureQueryStatusResultInner>(){}.getType()).register(202, new TypeToken<PacketCaptureQueryStatusResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public List<PacketCaptureResultInner> list(String resourceGroupName, String networkWatcherName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName).toBlocking().single()).body();
    }

    public ServiceFuture<List<PacketCaptureResultInner>> listAsync(String resourceGroupName, String networkWatcherName, ServiceCallback<List<PacketCaptureResultInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName), serviceCallback);
    }

    public Observable<List<PacketCaptureResultInner>> listAsync(String resourceGroupName, String networkWatcherName) {
        return this.listWithServiceResponseAsync(resourceGroupName, networkWatcherName).map((Func1)new Func1<ServiceResponse<List<PacketCaptureResultInner>>, List<PacketCaptureResultInner>>(){

            public List<PacketCaptureResultInner> call(ServiceResponse<List<PacketCaptureResultInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<PacketCaptureResultInner>>> listWithServiceResponseAsync(String resourceGroupName, String networkWatcherName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (networkWatcherName == null) {
            throw new IllegalArgumentException("Parameter networkWatcherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(resourceGroupName, networkWatcherName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PacketCaptureResultInner>>>>(){

            public Observable<ServiceResponse<List<PacketCaptureResultInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PacketCapturesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<PacketCaptureResultInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<PacketCaptureResultInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface PacketCapturesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Body PacketCaptureInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Body PacketCaptureInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures stop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/stop")
        public Observable<Response<ResponseBody>> stop(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginStop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/stop")
        public Observable<Response<ResponseBody>> beginStop(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures getStatus"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/queryStatus")
        public Observable<Response<ResponseBody>> getStatus(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures beginGetStatus"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/queryStatus")
        public Observable<Response<ResponseBody>> beginGetStatus(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="packetCaptureName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PacketCaptures list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="networkWatcherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

