/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PrivateEndpointInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PrivateEndpointsInner
implements InnerSupportsGet<PrivateEndpointInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<PrivateEndpointInner> {
    private PrivateEndpointsService service;
    private NetworkManagementClientImpl client;

    public PrivateEndpointsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PrivateEndpointsService)retrofit.create(PrivateEndpointsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String privateEndpointName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, privateEndpointName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String privateEndpointName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, privateEndpointName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String privateEndpointName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, privateEndpointName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String privateEndpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (privateEndpointName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, privateEndpointName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String privateEndpointName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, privateEndpointName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String privateEndpointName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, privateEndpointName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String privateEndpointName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, privateEndpointName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String privateEndpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (privateEndpointName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, privateEndpointName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateEndpointInner getByResourceGroup(String resourceGroupName, String privateEndpointName) {
        return (PrivateEndpointInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, privateEndpointName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointInner> getByResourceGroupAsync(String resourceGroupName, String privateEndpointName, ServiceCallback<PrivateEndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, privateEndpointName), serviceCallback);
    }

    public Observable<PrivateEndpointInner> getByResourceGroupAsync(String resourceGroupName, String privateEndpointName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, privateEndpointName).map((Func1)new Func1<ServiceResponse<PrivateEndpointInner>, PrivateEndpointInner>(){

            public PrivateEndpointInner call(ServiceResponse<PrivateEndpointInner> response) {
                return (PrivateEndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String privateEndpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (privateEndpointName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, privateEndpointName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PrivateEndpointInner getByResourceGroup(String resourceGroupName, String privateEndpointName, String expand) {
        return (PrivateEndpointInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, privateEndpointName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointInner> getByResourceGroupAsync(String resourceGroupName, String privateEndpointName, String expand, ServiceCallback<PrivateEndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, privateEndpointName, expand), serviceCallback);
    }

    public Observable<PrivateEndpointInner> getByResourceGroupAsync(String resourceGroupName, String privateEndpointName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, privateEndpointName, expand).map((Func1)new Func1<ServiceResponse<PrivateEndpointInner>, PrivateEndpointInner>(){

            public PrivateEndpointInner call(ServiceResponse<PrivateEndpointInner> response) {
                return (PrivateEndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String privateEndpointName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (privateEndpointName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, privateEndpointName, this.client.subscriptionId(), "2019-06-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateEndpointInner createOrUpdate(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return (PrivateEndpointInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, privateEndpointName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<PrivateEndpointInner> createOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, ServiceCallback<PrivateEndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, privateEndpointName, parameters), serviceCallback);
    }

    public Observable<PrivateEndpointInner> createOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, privateEndpointName, parameters).map((Func1)new Func1<ServiceResponse<PrivateEndpointInner>, PrivateEndpointInner>(){

            public PrivateEndpointInner call(ServiceResponse<PrivateEndpointInner> response) {
                return (PrivateEndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (privateEndpointName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, privateEndpointName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PrivateEndpointInner>(){}.getType());
    }

    public PrivateEndpointInner beginCreateOrUpdate(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return (PrivateEndpointInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, privateEndpointName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointInner> beginCreateOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, ServiceCallback<PrivateEndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, privateEndpointName, parameters), serviceCallback);
    }

    public Observable<PrivateEndpointInner> beginCreateOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, privateEndpointName, parameters).map((Func1)new Func1<ServiceResponse<PrivateEndpointInner>, PrivateEndpointInner>(){

            public PrivateEndpointInner call(ServiceResponse<PrivateEndpointInner> response) {
                return (PrivateEndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (privateEndpointName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, privateEndpointName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointInner>(){}.getType()).register(201, new TypeToken<PrivateEndpointInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateEndpointInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PrivateEndpointInner>((Page)response.body()){

            public Page<PrivateEndpointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<PrivateEndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(String nextPageLink) {
                return PrivateEndpointsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Page<PrivateEndpointInner>>(){

            public Page<PrivateEndpointInner> call(ServiceResponse<Page<PrivateEndpointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(ServiceResponse<Page<PrivateEndpointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateEndpointInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PrivateEndpointInner>((Page)response.body()){

            public Page<PrivateEndpointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointInner>> listAsync(ListOperationCallback<PrivateEndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(String nextPageLink) {
                return PrivateEndpointsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Page<PrivateEndpointInner>>(){

            public Page<PrivateEndpointInner> call(ServiceResponse<Page<PrivateEndpointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(ServiceResponse<Page<PrivateEndpointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateEndpointInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointInner>((Page)response.body()){

            public Page<PrivateEndpointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<PrivateEndpointInner>> serviceFuture, ListOperationCallback<PrivateEndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(String nextPageLink) {
                return PrivateEndpointsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Page<PrivateEndpointInner>>(){

            public Page<PrivateEndpointInner> call(ServiceResponse<Page<PrivateEndpointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(ServiceResponse<Page<PrivateEndpointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateEndpointInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointInner>((Page)response.body()){

            public Page<PrivateEndpointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateEndpointsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PrivateEndpointInner>> serviceFuture, ListOperationCallback<PrivateEndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(String nextPageLink) {
                return PrivateEndpointsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Page<PrivateEndpointInner>>(){

            public Page<PrivateEndpointInner> call(ServiceResponse<Page<PrivateEndpointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointInner>>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(ServiceResponse<Page<PrivateEndpointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateEndpointsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateEndpointsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface PrivateEndpointsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="privateEndpointName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="privateEndpointName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="privateEndpointName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="privateEndpointName") String var2, @Path(value="subscriptionId") String var3, @Body PrivateEndpointInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="privateEndpointName") String var2, @Path(value="subscriptionId") String var3, @Body PrivateEndpointInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/privateEndpoints")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateEndpoints listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

