/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnSiteLinkInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VpnSiteLinksInner {
    private VpnSiteLinksService service;
    private NetworkManagementClientImpl client;

    public VpnSiteLinksInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnSiteLinksService)retrofit.create(VpnSiteLinksService.class);
        this.client = client;
    }

    public VpnSiteLinkInner get(String resourceGroupName, String vpnSiteName, String vpnSiteLinkName) {
        return (VpnSiteLinkInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteLinkName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnSiteLinkInner> getAsync(String resourceGroupName, String vpnSiteName, String vpnSiteLinkName, ServiceCallback<VpnSiteLinkInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteLinkName), serviceCallback);
    }

    public Observable<VpnSiteLinkInner> getAsync(String resourceGroupName, String vpnSiteName, String vpnSiteLinkName) {
        return this.getWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteLinkName).map((Func1)new Func1<ServiceResponse<VpnSiteLinkInner>, VpnSiteLinkInner>(){

            public VpnSiteLinkInner call(ServiceResponse<VpnSiteLinkInner> response) {
                return (VpnSiteLinkInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteLinkInner>> getWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, String vpnSiteLinkName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        if (vpnSiteLinkName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteLinkName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, vpnSiteName, vpnSiteLinkName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteLinkInner>>>(){

            public Observable<ServiceResponse<VpnSiteLinkInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSiteLinksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnSiteLinkInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnSiteLinkInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteLinkInner> listByVpnSite(String resourceGroupName, String vpnSiteName) {
        ServiceResponse response = (ServiceResponse)this.listByVpnSiteSinglePageAsync(resourceGroupName, vpnSiteName).toBlocking().single();
        return new PagedList<VpnSiteLinkInner>((Page)response.body()){

            public Page<VpnSiteLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnSiteLinksInner.this.listByVpnSiteNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteLinkInner>> listByVpnSiteAsync(String resourceGroupName, String vpnSiteName, ListOperationCallback<VpnSiteLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVpnSiteSinglePageAsync(resourceGroupName, vpnSiteName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> call(String nextPageLink) {
                return VpnSiteLinksInner.this.listByVpnSiteNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteLinkInner>> listByVpnSiteAsync(String resourceGroupName, String vpnSiteName) {
        return this.listByVpnSiteWithServiceResponseAsync(resourceGroupName, vpnSiteName).map((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkInner>>, Page<VpnSiteLinkInner>>(){

            public Page<VpnSiteLinkInner> call(ServiceResponse<Page<VpnSiteLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> listByVpnSiteWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        return this.listByVpnSiteSinglePageAsync(resourceGroupName, vpnSiteName).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkInner>>, Observable<ServiceResponse<Page<VpnSiteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> call(ServiceResponse<Page<VpnSiteLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnSiteLinksInner.this.listByVpnSiteNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> listByVpnSiteSinglePageAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByVpnSite(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnSiteLinksInner.this.listByVpnSiteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteLinkInner>> listByVpnSiteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteLinkInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteLinkInner> listByVpnSiteNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByVpnSiteNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnSiteLinkInner>((Page)response.body()){

            public Page<VpnSiteLinkInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnSiteLinksInner.this.listByVpnSiteNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteLinkInner>> listByVpnSiteNextAsync(String nextPageLink, ServiceFuture<List<VpnSiteLinkInner>> serviceFuture, ListOperationCallback<VpnSiteLinkInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVpnSiteNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> call(String nextPageLink) {
                return VpnSiteLinksInner.this.listByVpnSiteNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteLinkInner>> listByVpnSiteNextAsync(String nextPageLink) {
        return this.listByVpnSiteNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkInner>>, Page<VpnSiteLinkInner>>(){

            public Page<VpnSiteLinkInner> call(ServiceResponse<Page<VpnSiteLinkInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> listByVpnSiteNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByVpnSiteNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkInner>>, Observable<ServiceResponse<Page<VpnSiteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> call(ServiceResponse<Page<VpnSiteLinkInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnSiteLinksInner.this.listByVpnSiteNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> listByVpnSiteNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByVpnSiteNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteLinkInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnSiteLinksInner.this.listByVpnSiteNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteLinkInner>> listByVpnSiteNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteLinkInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VpnSiteLinksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSiteLinks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}/vpnSiteLinks/{vpnSiteLinkName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Path(value="vpnSiteLinkName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSiteLinks listByVpnSite"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}/vpnSiteLinks")
        public Observable<Response<ResponseBody>> listByVpnSite(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSiteLinks listByVpnSiteNext"})
        @GET
        public Observable<Response<ResponseBody>> listByVpnSiteNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

