/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.implementation.OperationInner;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class OperationsInner {
    private OperationsService service;
    private StorageManagementClientImpl client;

    public OperationsInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (OperationsService)retrofit.create(OperationsService.class);
        this.client = client;
    }

    public List<OperationInner> list() {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<OperationInner>> listAsync(ServiceCallback<List<OperationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<OperationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<OperationInner>>, List<OperationInner>>(){

            public List<OperationInner> call(ServiceResponse<List<OperationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<OperationInner>>> listWithServiceResponseAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<OperationInner>>>>(){

            public Observable<ServiceResponse<List<OperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OperationsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OperationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface OperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Operations list"})
        @GET(value="providers/Microsoft.Storage/operations")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

