/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Blob index tag based filtering for blob objects.
 */
public class TagFilter {
    /**
     * This is the filter tag name, it can have 1 - 128 characters.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * This is the comparison operator which is used for object comparison and
     * filtering. Only == (equality operator) is currently supported.
     */
    @JsonProperty(value = "op", required = true)
    private String op;

    /**
     * This is the filter tag value field used for tag based filtering, it can
     * have 0 - 256 characters.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /**
     * Get this is the filter tag name, it can have 1 - 128 characters.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set this is the filter tag name, it can have 1 - 128 characters.
     *
     * @param name the name value to set
     * @return the TagFilter object itself.
     */
    public TagFilter withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get this is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported.
     *
     * @return the op value
     */
    public String op() {
        return this.op;
    }

    /**
     * Set this is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported.
     *
     * @param op the op value to set
     * @return the TagFilter object itself.
     */
    public TagFilter withOp(String op) {
        this.op = op;
        return this;
    }

    /**
     * Get this is the filter tag value field used for tag based filtering, it can have 0 - 256 characters.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set this is the filter tag value field used for tag based filtering, it can have 0 - 256 characters.
     *
     * @param value the value value to set
     * @return the TagFilter object itself.
     */
    public TagFilter withValue(String value) {
        this.value = value;
        return this;
    }

}
