/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Virtual Network rule.
 */
public class VirtualNetworkRule {
    /**
     * Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     */
    @JsonProperty(value = "id", required = true)
    private String virtualNetworkResourceId;

    /**
     * The action of virtual network rule. Possible values include: 'Allow'.
     */
    @JsonProperty(value = "action")
    private Action action;

    /**
     * Gets the state of virtual network rule. Possible values include:
     * 'provisioning', 'deprovisioning', 'succeeded', 'failed',
     * 'networkSourceDeleted'.
     */
    @JsonProperty(value = "state")
    private State state;

    /**
     * Get resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     *
     * @return the virtualNetworkResourceId value
     */
    public String virtualNetworkResourceId() {
        return this.virtualNetworkResourceId;
    }

    /**
     * Set resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
     *
     * @param virtualNetworkResourceId the virtualNetworkResourceId value to set
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withVirtualNetworkResourceId(String virtualNetworkResourceId) {
        this.virtualNetworkResourceId = virtualNetworkResourceId;
        return this;
    }

    /**
     * Get the action of virtual network rule. Possible values include: 'Allow'.
     *
     * @return the action value
     */
    public Action action() {
        return this.action;
    }

    /**
     * Set the action of virtual network rule. Possible values include: 'Allow'.
     *
     * @param action the action value to set
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withAction(Action action) {
        this.action = action;
        return this;
    }

    /**
     * Get gets the state of virtual network rule. Possible values include: 'provisioning', 'deprovisioning', 'succeeded', 'failed', 'networkSourceDeleted'.
     *
     * @return the state value
     */
    public State state() {
        return this.state;
    }

    /**
     * Set gets the state of virtual network rule. Possible values include: 'provisioning', 'deprovisioning', 'succeeded', 'failed', 'networkSourceDeleted'.
     *
     * @param state the state value to set
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withState(State state) {
        this.state = state;
        return this;
    }

}
