/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.storage.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in EncryptionScopes.
 */
public class EncryptionScopesInner {
    /** The Retrofit service to perform REST calls. */
    private EncryptionScopesService service;
    /** The service client containing this operation class. */
    private StorageManagementClientImpl client;

    /**
     * Initializes an instance of EncryptionScopesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public EncryptionScopesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = retrofit.create(EncryptionScopesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for EncryptionScopes to be
     * used by Retrofit to perform actually REST calls.
     */
    interface EncryptionScopesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes put" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        Observable<Response<ResponseBody>> put(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Path("encryptionScopeName") String encryptionScopeName, @Query("api-version") String apiVersion, @Body EncryptionScopeInner encryptionScope, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes patch" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        Observable<Response<ResponseBody>> patch(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Path("encryptionScopeName") String encryptionScopeName, @Query("api-version") String apiVersion, @Body EncryptionScopeInner encryptionScope, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Path("encryptionScopeName") String encryptionScopeName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Synchronously creates or updates an encryption scope under the specified storage account. If an encryption scope is already created and a subsequent request is issued with different properties, the encryption scope properties will be updated per the specified request.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EncryptionScopeInner object if successful.
     */
    public EncryptionScopeInner put(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return putWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).toBlocking().single().body();
    }

    /**
     * Synchronously creates or updates an encryption scope under the specified storage account. If an encryption scope is already created and a subsequent request is issued with different properties, the encryption scope properties will be updated per the specified request.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the create or update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EncryptionScopeInner> putAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, final ServiceCallback<EncryptionScopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(putWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope), serviceCallback);
    }

    /**
     * Synchronously creates or updates an encryption scope under the specified storage account. If an encryption scope is already created and a subsequent request is issued with different properties, the encryption scope properties will be updated per the specified request.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EncryptionScopeInner object
     */
    public Observable<EncryptionScopeInner> putAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return putWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).map(new Func1<ServiceResponse<EncryptionScopeInner>, EncryptionScopeInner>() {
            @Override
            public EncryptionScopeInner call(ServiceResponse<EncryptionScopeInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Synchronously creates or updates an encryption scope under the specified storage account. If an encryption scope is already created and a subsequent request is issued with different properties, the encryption scope properties will be updated per the specified request.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EncryptionScopeInner object
     */
    public Observable<ServiceResponse<EncryptionScopeInner>> putWithServiceResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (encryptionScopeName == null) {
            throw new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (encryptionScope == null) {
            throw new IllegalArgumentException("Parameter encryptionScope is required and cannot be null.");
        }
        Validator.validate(encryptionScope);
        return service.put(resourceGroupName, accountName, this.client.subscriptionId(), encryptionScopeName, this.client.apiVersion(), encryptionScope, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionScopeInner>>>() {
                @Override
                public Observable<ServiceResponse<EncryptionScopeInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EncryptionScopeInner> clientResponse = putDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EncryptionScopeInner> putDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EncryptionScopeInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EncryptionScopeInner>() { }.getType())
                .register(201, new TypeToken<EncryptionScopeInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Update encryption scope properties as specified in the request body. Update fails if the specified encryption scope does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EncryptionScopeInner object if successful.
     */
    public EncryptionScopeInner patch(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return patchWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).toBlocking().single().body();
    }

    /**
     * Update encryption scope properties as specified in the request body. Update fails if the specified encryption scope does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EncryptionScopeInner> patchAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, final ServiceCallback<EncryptionScopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(patchWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope), serviceCallback);
    }

    /**
     * Update encryption scope properties as specified in the request body. Update fails if the specified encryption scope does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EncryptionScopeInner object
     */
    public Observable<EncryptionScopeInner> patchAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return patchWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).map(new Func1<ServiceResponse<EncryptionScopeInner>, EncryptionScopeInner>() {
            @Override
            public EncryptionScopeInner call(ServiceResponse<EncryptionScopeInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update encryption scope properties as specified in the request body. Update fails if the specified encryption scope does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param encryptionScope Encryption scope properties to be used for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EncryptionScopeInner object
     */
    public Observable<ServiceResponse<EncryptionScopeInner>> patchWithServiceResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (encryptionScopeName == null) {
            throw new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (encryptionScope == null) {
            throw new IllegalArgumentException("Parameter encryptionScope is required and cannot be null.");
        }
        Validator.validate(encryptionScope);
        return service.patch(resourceGroupName, accountName, this.client.subscriptionId(), encryptionScopeName, this.client.apiVersion(), encryptionScope, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionScopeInner>>>() {
                @Override
                public Observable<ServiceResponse<EncryptionScopeInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EncryptionScopeInner> clientResponse = patchDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EncryptionScopeInner> patchDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EncryptionScopeInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EncryptionScopeInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Returns the properties for the specified encryption scope.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EncryptionScopeInner object if successful.
     */
    public EncryptionScopeInner get(String resourceGroupName, String accountName, String encryptionScopeName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName).toBlocking().single().body();
    }

    /**
     * Returns the properties for the specified encryption scope.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EncryptionScopeInner> getAsync(String resourceGroupName, String accountName, String encryptionScopeName, final ServiceCallback<EncryptionScopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName), serviceCallback);
    }

    /**
     * Returns the properties for the specified encryption scope.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EncryptionScopeInner object
     */
    public Observable<EncryptionScopeInner> getAsync(String resourceGroupName, String accountName, String encryptionScopeName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName).map(new Func1<ServiceResponse<EncryptionScopeInner>, EncryptionScopeInner>() {
            @Override
            public EncryptionScopeInner call(ServiceResponse<EncryptionScopeInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns the properties for the specified encryption scope.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EncryptionScopeInner object
     */
    public Observable<ServiceResponse<EncryptionScopeInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (encryptionScopeName == null) {
            throw new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, accountName, this.client.subscriptionId(), encryptionScopeName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionScopeInner>>>() {
                @Override
                public Observable<ServiceResponse<EncryptionScopeInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EncryptionScopeInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EncryptionScopeInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EncryptionScopeInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EncryptionScopeInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;EncryptionScopeInner&gt; object if successful.
     */
    public PagedList<EncryptionScopeInner> list(final String resourceGroupName, final String accountName) {
        ServiceResponse<Page<EncryptionScopeInner>> response = listSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<EncryptionScopeInner>(response.body()) {
            @Override
            public Page<EncryptionScopeInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<EncryptionScopeInner>> listAsync(final String resourceGroupName, final String accountName, final ListOperationCallback<EncryptionScopeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(resourceGroupName, accountName),
            new Func1<String, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EncryptionScopeInner&gt; object
     */
    public Observable<Page<EncryptionScopeInner>> listAsync(final String resourceGroupName, final String accountName) {
        return listWithServiceResponseAsync(resourceGroupName, accountName)
            .map(new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Page<EncryptionScopeInner>>() {
                @Override
                public Page<EncryptionScopeInner> call(ServiceResponse<Page<EncryptionScopeInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EncryptionScopeInner&gt; object
     */
    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listWithServiceResponseAsync(final String resourceGroupName, final String accountName) {
        return listSinglePageAsync(resourceGroupName, accountName)
            .concatMap(new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(ServiceResponse<Page<EncryptionScopeInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
    ServiceResponse<PageImpl1<EncryptionScopeInner>> * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
    ServiceResponse<PageImpl1<EncryptionScopeInner>> * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;EncryptionScopeInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listSinglePageAsync(final String resourceGroupName, final String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<EncryptionScopeInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<EncryptionScopeInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<EncryptionScopeInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<EncryptionScopeInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<EncryptionScopeInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;EncryptionScopeInner&gt; object if successful.
     */
    public PagedList<EncryptionScopeInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<EncryptionScopeInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EncryptionScopeInner>(response.body()) {
            @Override
            public Page<EncryptionScopeInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<EncryptionScopeInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<EncryptionScopeInner>> serviceFuture, final ListOperationCallback<EncryptionScopeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EncryptionScopeInner&gt; object
     */
    public Observable<Page<EncryptionScopeInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Page<EncryptionScopeInner>>() {
                @Override
                public Page<EncryptionScopeInner> call(ServiceResponse<Page<EncryptionScopeInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EncryptionScopeInner&gt; object
     */
    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(ServiceResponse<Page<EncryptionScopeInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all the encryption scopes available under the specified storage account.
     *
    ServiceResponse<PageImpl1<EncryptionScopeInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;EncryptionScopeInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<EncryptionScopeInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<EncryptionScopeInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<EncryptionScopeInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<EncryptionScopeInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<EncryptionScopeInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
