/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.MessageBody;
import com.microsoft.azure.servicebus.MessageBodyType;
import com.microsoft.azure.servicebus.Utils;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.MessageWithDeliveryTag;
import com.microsoft.azure.servicebus.primitives.MessageWithLockToken;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.Util;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

class MessageConverter {
    MessageConverter() {
    }

    public static org.apache.qpid.proton.message.Message convertBrokeredMessageToAmqpMessage(Message brokeredMessage) {
        org.apache.qpid.proton.message.Message amqpMessage = Proton.message();
        MessageBody body = brokeredMessage.getMessageBody();
        if (body != null) {
            if (body.getBodyType() == MessageBodyType.VALUE) {
                amqpMessage.setBody((Section)new AmqpValue(body.getValueData()));
            } else if (body.getBodyType() == MessageBodyType.SEQUENCE) {
                amqpMessage.setBody((Section)new AmqpSequence(Utils.getSequenceFromMessageBody(body)));
            } else {
                amqpMessage.setBody((Section)new Data(new Binary(Utils.getDataFromMessageBody(body))));
            }
        }
        if (brokeredMessage.getProperties() != null) {
            amqpMessage.setApplicationProperties(new ApplicationProperties(brokeredMessage.getProperties()));
        }
        if (brokeredMessage.getTimeToLive() != null) {
            amqpMessage.setTtl(brokeredMessage.getTimeToLive().toMillis());
        }
        amqpMessage.setMessageId((Object)brokeredMessage.getMessageId());
        amqpMessage.setContentType(brokeredMessage.getContentType());
        amqpMessage.setCorrelationId((Object)brokeredMessage.getCorrelationId());
        amqpMessage.setSubject(brokeredMessage.getLabel());
        amqpMessage.getProperties().setTo(brokeredMessage.getTo());
        amqpMessage.setReplyTo(brokeredMessage.getReplyTo());
        amqpMessage.setReplyToGroupId(brokeredMessage.getReplyToSessionId());
        amqpMessage.setGroupId(brokeredMessage.getSessionId());
        HashMap<Symbol, Object> messageAnnotationsMap = new HashMap<Symbol, Object>();
        if (brokeredMessage.getScheduledEnqueueTimeUtc() != null) {
            messageAnnotationsMap.put(Symbol.valueOf((String)"x-opt-scheduled-enqueue-time"), Date.from(brokeredMessage.getScheduledEnqueueTimeUtc()));
        }
        if (!StringUtil.isNullOrEmpty(brokeredMessage.getPartitionKey())) {
            messageAnnotationsMap.put(Symbol.valueOf((String)"x-opt-partition-key"), brokeredMessage.getPartitionKey());
        }
        if (!StringUtil.isNullOrEmpty(brokeredMessage.getViaPartitionKey())) {
            messageAnnotationsMap.put(Symbol.valueOf((String)"x-opt-via-partition-key"), brokeredMessage.getViaPartitionKey());
        }
        amqpMessage.setMessageAnnotations(new MessageAnnotations(messageAnnotationsMap));
        return amqpMessage;
    }

    public static Message convertAmqpMessageToBrokeredMessage(org.apache.qpid.proton.message.Message amqpMessage) {
        return MessageConverter.convertAmqpMessageToBrokeredMessage(amqpMessage, null);
    }

    public static Message convertAmqpMessageToBrokeredMessage(MessageWithDeliveryTag amqpMessageWithDeliveryTag) {
        org.apache.qpid.proton.message.Message amqpMessage = amqpMessageWithDeliveryTag.getMessage();
        byte[] deliveryTag = amqpMessageWithDeliveryTag.getDeliveryTag();
        return MessageConverter.convertAmqpMessageToBrokeredMessage(amqpMessage, deliveryTag);
    }

    public static Message convertAmqpMessageToBrokeredMessage(MessageWithLockToken amqpMessageWithLockToken) {
        Message convertedMessage = MessageConverter.convertAmqpMessageToBrokeredMessage(amqpMessageWithLockToken.getMessage(), null);
        convertedMessage.setLockToken(amqpMessageWithLockToken.getLockToken());
        return convertedMessage;
    }

    public static Message convertAmqpMessageToBrokeredMessage(org.apache.qpid.proton.message.Message amqpMessage, byte[] deliveryTag) {
        Map messageAnnotationsMap;
        Properties properties;
        Message brokeredMessage;
        Section body = amqpMessage.getBody();
        if (body != null) {
            Object messageData;
            if (body instanceof Data) {
                messageData = ((Data)body).getValue();
                brokeredMessage = new Message(Utils.fromBinay(messageData.getArray()));
            } else if (body instanceof AmqpValue) {
                messageData = ((AmqpValue)body).getValue();
                brokeredMessage = new Message(MessageBody.fromValueData(messageData));
            } else if (body instanceof AmqpSequence) {
                messageData = ((AmqpSequence)body).getValue();
                brokeredMessage = new Message(Utils.fromSequence((List<Object>)messageData));
            } else {
                brokeredMessage = new Message();
            }
        } else {
            brokeredMessage = new Message();
        }
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        if (applicationProperties != null) {
            brokeredMessage.setProperties(applicationProperties.getValue());
        }
        brokeredMessage.setTimeToLive(Duration.ofMillis(amqpMessage.getTtl()));
        brokeredMessage.setDeliveryCount(amqpMessage.getDeliveryCount());
        Object messageId = amqpMessage.getMessageId();
        if (messageId != null) {
            brokeredMessage.setMessageId(messageId.toString());
        }
        brokeredMessage.setContentType(amqpMessage.getContentType());
        Object correlationId = amqpMessage.getCorrelationId();
        if (correlationId != null) {
            brokeredMessage.setCorrelationId(correlationId.toString());
        }
        if ((properties = amqpMessage.getProperties()) != null) {
            brokeredMessage.setTo(properties.getTo());
        }
        brokeredMessage.setLabel(amqpMessage.getSubject());
        brokeredMessage.setReplyTo(amqpMessage.getReplyTo());
        brokeredMessage.setReplyToSessionId(amqpMessage.getReplyToGroupId());
        brokeredMessage.setSessionId(amqpMessage.getGroupId());
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        if (messageAnnotations != null && (messageAnnotationsMap = messageAnnotations.getValue()) != null) {
            for (Map.Entry entry : messageAnnotationsMap.entrySet()) {
                String entryName;
                switch (entryName = ((Symbol)entry.getKey()).toString()) {
                    case "x-opt-enqueued-time": {
                        brokeredMessage.setEnqueuedTimeUtc(((Date)entry.getValue()).toInstant());
                        break;
                    }
                    case "x-opt-scheduled-enqueue-time": {
                        brokeredMessage.setScheduledEnqueueTimeUtc(((Date)entry.getValue()).toInstant());
                        break;
                    }
                    case "x-opt-sequence-number": {
                        brokeredMessage.setSequenceNumber((Long)entry.getValue());
                        break;
                    }
                    case "x-opt-locked-until": {
                        brokeredMessage.setLockedUntilUtc(((Date)entry.getValue()).toInstant());
                        break;
                    }
                    case "x-opt-partition-key": {
                        brokeredMessage.setPartitionKey((String)entry.getValue());
                        break;
                    }
                    case "x-opt-via-partition-key": {
                        brokeredMessage.setViaPartitionKey((String)entry.getValue());
                        break;
                    }
                    case "x-opt-deadletter-source": {
                        brokeredMessage.setDeadLetterSource((String)entry.getValue());
                        break;
                    }
                }
            }
        }
        if (deliveryTag != null && deliveryTag.length == 16) {
            UUID lockToken = Util.convertDotNetBytesToUUID(deliveryTag);
            brokeredMessage.setLockToken(lockToken);
        } else {
            brokeredMessage.setLockToken(ClientConstants.ZEROLOCKTOKEN);
        }
        brokeredMessage.setDeliveryTag(deliveryTag);
        return brokeredMessage;
    }
}

