/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.AccessRights;
import com.microsoft.azure.servicebus.management.AuthorizationRule;
import com.microsoft.azure.servicebus.management.SharedAccessAuthorizationRule;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthorizationRuleSerializer {
    static Element serializeRules(List<AuthorizationRule> authorizationRules, Document doc) throws ServiceBusException {
        if (authorizationRules == null) {
            return null;
        }
        Element rules = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
        for (AuthorizationRule rule : authorizationRules) {
            rules.appendChild(AuthorizationRuleSerializer.serializeRule(rule, doc));
        }
        return rules;
    }

    private static Element serializeRule(AuthorizationRule authRule, Document doc) {
        if (authRule instanceof SharedAccessAuthorizationRule) {
            return AuthorizationRuleSerializer.serializeSasRule((SharedAccessAuthorizationRule)authRule, doc);
        }
        return null;
    }

    private static Element serializeSasRule(SharedAccessAuthorizationRule sasRule, Document doc) {
        Element authRule = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule");
        authRule.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", "SharedAccessAuthorizationRule");
        authRule.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType").appendChild(doc.createTextNode(sasRule.getClaimType())).getParentNode());
        authRule.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue").appendChild(doc.createTextNode(sasRule.getClaimValue())).getParentNode());
        if (sasRule.getRights() != null) {
            Element rights = doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
            authRule.appendChild(rights);
            for (AccessRights right : sasRule.getRights()) {
                rights.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").appendChild(doc.createTextNode(right.name())).getParentNode());
            }
        }
        authRule.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName").appendChild(doc.createTextNode(sasRule.getKeyName())).getParentNode());
        authRule.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey").appendChild(doc.createTextNode(sasRule.getPrimaryKey())).getParentNode());
        authRule.appendChild(doc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey").appendChild(doc.createTextNode(sasRule.getSecondaryKey())).getParentNode());
        return authRule;
    }

    static List<AuthorizationRule> parseAuthRules(Element xEntry) {
        ArrayList<AuthorizationRule> rules = null;
        NodeList nList = xEntry.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equalsIgnoreCase("AuthorizationRule")) continue;
            if (rules == null) {
                rules = new ArrayList<AuthorizationRule>();
            }
            rules.add(AuthorizationRuleSerializer.parseAuthRule((Element)node));
        }
        return rules;
    }

    private static AuthorizationRule parseAuthRule(Element xEntry) {
        NamedNodeMap attributes = xEntry.getAttributes();
        if (attributes == null || attributes.getLength() < 1) {
            return null;
        }
        String type = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attributeNode = attributes.item(i);
            if (!attributeNode.getNodeName().endsWith("type")) continue;
            type = attributeNode.getNodeValue();
            break;
        }
        if (type == null) {
            return null;
        }
        switch (type) {
            case "SharedAccessAuthorizationRule": {
                return AuthorizationRuleSerializer.parseSasAuthRule(xEntry);
            }
        }
        return null;
    }

    private static AuthorizationRule parseSasAuthRule(Element xEntry) {
        SharedAccessAuthorizationRule rule = new SharedAccessAuthorizationRule();
        NodeList nList = xEntry.getChildNodes();
        block16: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "CreatedTime": {
                    rule.setCreatedTime(Instant.parse(element.getFirstChild().getNodeValue()));
                    continue block16;
                }
                case "ModifiedTime": {
                    rule.setModifiedTime(Instant.parse(element.getFirstChild().getNodeValue()));
                    continue block16;
                }
                case "KeyName": {
                    rule.setKeyName(element.getFirstChild().getNodeValue());
                    continue block16;
                }
                case "PrimaryKey": {
                    rule.setPrimaryKey(element.getFirstChild().getNodeValue());
                    continue block16;
                }
                case "SecondaryKey": {
                    rule.setSecondaryKey(element.getFirstChild().getNodeValue());
                    continue block16;
                }
                case "Rights": {
                    ArrayList<AccessRights> rights = new ArrayList<AccessRights>();
                    NodeList rightsList = element.getChildNodes();
                    for (int j = 0; j < rightsList.getLength(); ++j) {
                        Node rightNode = rightsList.item(j);
                        if (rightNode.getNodeType() != 1) continue;
                        Element rightElement = (Element)rightNode;
                        rights.add(AccessRights.valueOf(rightElement.getFirstChild().getNodeValue()));
                    }
                    rule.setRights(rights);
                    continue block16;
                }
            }
        }
        return rule;
    }

    static boolean equals(List<AuthorizationRule> first, List<AuthorizationRule> second) {
        if (first == null && second != null || first != null && second == null) {
            return false;
        }
        if (first == null) {
            return true;
        }
        if (first.size() != second.size()) {
            return false;
        }
        HashMap<String, AuthorizationRule> cnt = new HashMap<String, AuthorizationRule>();
        for (AuthorizationRule rule : first) {
            cnt.put(rule.getKeyName(), rule);
        }
        for (AuthorizationRule otherRule : second) {
            AuthorizationRule firstRule = (AuthorizationRule)cnt.get(otherRule.getKeyName());
            if (firstRule != null && firstRule.equals(otherRule)) continue;
            return false;
        }
        return true;
    }
}

