/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.Utils;
import com.microsoft.azure.servicebus.management.ManagementClientAsync;
import com.microsoft.azure.servicebus.management.NamespaceInfo;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.management.QueueRuntimeInfo;
import com.microsoft.azure.servicebus.management.SubscriptionDescription;
import com.microsoft.azure.servicebus.management.SubscriptionRuntimeInfo;
import com.microsoft.azure.servicebus.management.TopicDescription;
import com.microsoft.azure.servicebus.management.TopicRuntimeInfo;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.primitives.Util;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class ManagementClient {
    private ManagementClientAsync asyncClient;

    public ManagementClient(ConnectionStringBuilder connectionStringBuilder) {
        this(connectionStringBuilder.getEndpoint(), Util.getClientSettingsFromConnectionStringBuilder(connectionStringBuilder));
    }

    public ManagementClient(URI namespaceEndpointURI, ClientSettings clientSettings) {
        this.asyncClient = new ManagementClientAsync(namespaceEndpointURI, clientSettings);
    }

    public NamespaceInfo getNamespaceInfo() throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getNamespaceInfoAsync());
    }

    public QueueDescription getQueue(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getQueueAsync(path));
    }

    public QueueRuntimeInfo getQueueRuntimeInfo(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getQueueRuntimeInfoAsync(path));
    }

    public TopicDescription getTopic(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getTopicAsync(path));
    }

    public TopicRuntimeInfo getTopicRuntimeInfo(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getTopicRuntimeInfoAsync(path));
    }

    public SubscriptionDescription getSubscription(String topicPath, String subscriptionName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getSubscriptionAsync(topicPath, subscriptionName));
    }

    public SubscriptionRuntimeInfo getSubscriptionRuntimeInfo(String topicPath, String subscriptionName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getSubscriptionRuntimeInfoAsync(topicPath, subscriptionName));
    }

    public RuleDescription getRule(String topicPath, String subscriptionName, String ruleName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getRuleAsync(topicPath, subscriptionName, ruleName));
    }

    public List<QueueDescription> getQueues() throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getQueuesAsync());
    }

    public List<QueueDescription> getQueues(int count, int skip) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getQueuesAsync(count, skip));
    }

    public List<TopicDescription> getTopics() throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getTopicsAsync());
    }

    public List<TopicDescription> getTopics(int count, int skip) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getTopicsAsync(count, skip));
    }

    public List<SubscriptionDescription> getSubscriptions(String topicName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getSubscriptionsAsync(topicName));
    }

    public List<SubscriptionDescription> getSubscriptions(String topicName, int count, int skip) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getSubscriptionsAsync(topicName, count, skip));
    }

    public List<RuleDescription> getRules(String topicName, String subscriptionName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getRulesAsync(topicName, subscriptionName));
    }

    public List<RuleDescription> getRules(String topicName, String subscriptionName, int count, int skip) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.getRulesAsync(topicName, subscriptionName, count, skip));
    }

    public QueueDescription createQueue(String queuePath) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createQueueAsync(queuePath));
    }

    public QueueDescription createQueue(QueueDescription queueDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createQueueAsync(queueDescription));
    }

    public QueueDescription updateQueue(QueueDescription queueDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.updateQueueAsync(queueDescription));
    }

    public TopicDescription createTopic(String topicPath) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createTopicAsync(topicPath));
    }

    public TopicDescription createTopic(TopicDescription topicDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createTopicAsync(topicDescription));
    }

    public TopicDescription updateTopic(TopicDescription topicDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.updateTopicAsync(topicDescription));
    }

    public SubscriptionDescription createSubscription(String topicPath, String subscriptionName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createSubscriptionAsync(topicPath, subscriptionName));
    }

    public SubscriptionDescription createSubscription(SubscriptionDescription subscriptionDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createSubscriptionAsync(subscriptionDescription));
    }

    public SubscriptionDescription createSubscription(SubscriptionDescription subscriptionDescription, RuleDescription defaultRule) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createSubscriptionAsync(subscriptionDescription, defaultRule));
    }

    public SubscriptionDescription updateSubscription(SubscriptionDescription subscriptionDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.updateSubscriptionAsync(subscriptionDescription));
    }

    public RuleDescription createRule(String topicName, String subscriptionName, RuleDescription ruleDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.createRuleAsync(topicName, subscriptionName, ruleDescription));
    }

    public RuleDescription updateRule(String topicName, String subscriptionName, RuleDescription ruleDescription) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.updateRuleAsync(topicName, subscriptionName, ruleDescription));
    }

    public Boolean queueExists(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.queueExistsAsync(path));
    }

    public Boolean topicExists(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.topicExistsAsync(path));
    }

    public Boolean subscriptionExists(String topicPath, String subscriptionName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.subscriptionExistsAsync(topicPath, subscriptionName));
    }

    public Boolean ruleExists(String topicPath, String subscriptionName, String ruleName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.ruleExistsAsync(topicPath, subscriptionName, ruleName));
    }

    public Void deleteQueue(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.deleteQueueAsync(path));
    }

    public Void deleteTopic(String path) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.deleteTopicAsync(path));
    }

    public Void deleteSubscription(String topicPath, String subscriptionName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.deleteSubscriptionAsync(topicPath, subscriptionName));
    }

    public Void deleteRule(String topicPath, String subscriptionName, String ruleName) throws ServiceBusException, InterruptedException {
        return Utils.completeFuture(this.asyncClient.deleteRuleAsync(topicPath, subscriptionName, ruleName));
    }

    public void close() throws IOException {
        this.asyncClient.close();
    }
}

