/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.MessageCountDetails;
import com.microsoft.azure.servicebus.management.SerializerUtil;
import com.microsoft.azure.servicebus.management.TopicRuntimeInfo;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Instant;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TopicRuntimeInfoSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(TopicRuntimeInfoSerializer.class);

    static TopicRuntimeInfo parseFromContent(String xml) throws MessagingEntityNotFoundException {
        block4: {
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if ("entry".equals(doc.getTagName())) {
                    return TopicRuntimeInfoSerializer.parseFromEntry(doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Topic was not found");
    }

    private static TopicRuntimeInfo parseFromEntry(Node xEntry) {
        TopicRuntimeInfo topicRuntimeInfo = null;
        NodeList nList = xEntry.getChildNodes();
        block38: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    topicRuntimeInfo = new TopicRuntimeInfo(element.getFirstChild().getNodeValue());
                    continue block38;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block39: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "AccessedAt": {
                                topicRuntimeInfo.setAccessedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "CreatedAt": {
                                topicRuntimeInfo.setCreatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "UpdatedAt": {
                                topicRuntimeInfo.setUpdatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "SubscriptionCount": {
                                topicRuntimeInfo.setSubscriptionCount(Integer.parseInt(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "SizeInBytes": {
                                topicRuntimeInfo.setSizeInBytes(Long.parseLong(element.getFirstChild().getNodeValue()));
                                continue block39;
                            }
                            case "CountDetails": {
                                topicRuntimeInfo.setMessageCountDetails(new MessageCountDetails());
                                NodeList mcDetails = element.getChildNodes();
                                block40: for (int k = 0; k < mcDetails.getLength(); ++k) {
                                    String localName;
                                    Node node2 = mcDetails.item(k);
                                    if (node2.getNodeType() != 1) continue;
                                    element = (Element)node2;
                                    switch (localName = element.getTagName().substring(element.getTagName().indexOf(58) + 1)) {
                                        case "ActiveMessageCount": {
                                            topicRuntimeInfo.getMessageCountDetails().setActiveMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "DeadLetterMessageCount": {
                                            topicRuntimeInfo.getMessageCountDetails().setDeadLetterMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "ScheduledMessageCount": {
                                            topicRuntimeInfo.getMessageCountDetails().setScheduledMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "TransferMessageCount": {
                                            topicRuntimeInfo.getMessageCountDetails().setTransferMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                        case "TransferDeadLetterMessageCount": {
                                            topicRuntimeInfo.getMessageCountDetails().setTransferDeadLetterMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block40;
                                        }
                                    }
                                }
                                continue block39;
                            }
                        }
                    }
                    continue block38;
                }
            }
        }
        return topicRuntimeInfo;
    }
}

