/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.ExceptionUtil;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.rules.CorrelationFilter;
import com.microsoft.azure.servicebus.rules.FalseFilter;
import com.microsoft.azure.servicebus.rules.Filter;
import com.microsoft.azure.servicebus.rules.RuleAction;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import com.microsoft.azure.servicebus.rules.SqlFilter;
import com.microsoft.azure.servicebus.rules.SqlRuleAction;
import com.microsoft.azure.servicebus.rules.TrueFilter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;

public class RequestResponseUtils {
    public static Message createRequestMessageFromPropertyBag(String operation, Map propertyBag, Duration timeout) {
        return RequestResponseUtils.createRequestMessageFromPropertyBag(operation, propertyBag, timeout, null);
    }

    public static Message createRequestMessageFromPropertyBag(String operation, Map propertyBag, Duration timeout, String associatedLinkName) {
        return RequestResponseUtils.createRequestMessageFromValueBody(operation, propertyBag, timeout, associatedLinkName);
    }

    public static Message createRequestMessageFromValueBody(String operation, Object valueBody, Duration timeout) {
        return RequestResponseUtils.createRequestMessageFromValueBody(operation, valueBody, timeout, null);
    }

    private static Message createRequestMessageFromValueBody(String operation, Object valueBody, Duration timeout, String associatedLinkName) {
        Message requestMessage = Message.Factory.create();
        requestMessage.setBody((Section)new AmqpValue(valueBody));
        HashMap<String, Object> applicationPropertiesMap = new HashMap<String, Object>();
        applicationPropertiesMap.put("operation", operation);
        applicationPropertiesMap.put("com.microsoft:server-timeout", timeout.toMillis());
        if (!StringUtil.isNullOrEmpty(associatedLinkName)) {
            applicationPropertiesMap.put("associated-link-name", associatedLinkName);
        }
        requestMessage.setApplicationProperties(new ApplicationProperties(applicationPropertiesMap));
        return requestMessage;
    }

    public static int getResponseStatusCode(Message responseMessage) {
        int statusCode = -1;
        Object codeObject = responseMessage.getApplicationProperties().getValue().get("statusCode");
        if (codeObject == null) {
            codeObject = responseMessage.getApplicationProperties().getValue().get("status-code");
        }
        if (codeObject != null) {
            statusCode = (Integer)codeObject;
        }
        return statusCode;
    }

    public static Symbol getResponseErrorCondition(Message responseMessage) {
        Symbol errorCondition = (Symbol)responseMessage.getApplicationProperties().getValue().get("errorCondition");
        if (errorCondition == null) {
            errorCondition = (Symbol)responseMessage.getApplicationProperties().getValue().get("error-condition");
        }
        return errorCondition;
    }

    public static String getResponseStatusDescription(Message responseMessage) {
        String statusDescription = (String)responseMessage.getApplicationProperties().getValue().get("statusDescription");
        if (statusDescription == null) {
            statusDescription = (String)responseMessage.getApplicationProperties().getValue().get("status-description");
        }
        return statusDescription;
    }

    public static Map getResponseBody(Message responseMessage) {
        return (Map)((AmqpValue)responseMessage.getBody()).getValue();
    }

    public static Exception genereateExceptionFromResponse(Message responseMessage) {
        Symbol errorCondition = RequestResponseUtils.getResponseErrorCondition(responseMessage);
        String statusDescription = RequestResponseUtils.getResponseStatusDescription(responseMessage);
        return RequestResponseUtils.generateExceptionFromError(errorCondition, statusDescription == null ? errorCondition.toString() : statusDescription);
    }

    public static Exception generateExceptionFromError(Symbol errorCondition, String exceptionMessage) {
        return ExceptionUtil.toException(new ErrorCondition(errorCondition, exceptionMessage));
    }

    public static Map<String, Object> encodeRuleDescriptionToMap(RuleDescription ruleDescription) {
        HashMap<String, Object> descriptionMap = new HashMap<String, Object>();
        if (ruleDescription.getFilter() instanceof SqlFilter) {
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("expression", ((SqlFilter)ruleDescription.getFilter()).getSqlExpression());
            descriptionMap.put("sql-filter", filterMap);
        } else if (ruleDescription.getFilter() instanceof CorrelationFilter) {
            CorrelationFilter correlationFilter = (CorrelationFilter)ruleDescription.getFilter();
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("correlation-id", correlationFilter.getCorrelationId());
            filterMap.put("message-id", correlationFilter.getMessageId());
            filterMap.put("to", correlationFilter.getTo());
            filterMap.put("reply-to", correlationFilter.getReplyTo());
            filterMap.put("label", correlationFilter.getLabel());
            filterMap.put("session-id", correlationFilter.getSessionId());
            filterMap.put("reply-to-session-id", correlationFilter.getReplyToSessionId());
            filterMap.put("content-type", correlationFilter.getContentType());
            filterMap.put("properties", correlationFilter.getProperties());
            descriptionMap.put("correlation-filter", filterMap);
        } else {
            throw new IllegalArgumentException("This API supports the addition of only SQLFilters and CorrelationFilters.");
        }
        if (ruleDescription.getAction() == null) {
            descriptionMap.put("sql-rule-action", null);
        } else if (ruleDescription.getAction() instanceof SqlRuleAction) {
            HashMap<String, String> sqlActionMap = new HashMap<String, String>();
            sqlActionMap.put("expression", ((SqlRuleAction)ruleDescription.getAction()).getSqlExpression());
            descriptionMap.put("sql-rule-action", sqlActionMap);
        } else {
            throw new IllegalArgumentException("This API supports the addition of only filters with SqlRuleActions.");
        }
        descriptionMap.put("rule-name", ruleDescription.getName());
        return descriptionMap;
    }

    static RuleDescription decodeRuleDescriptionMap(DescribedType ruleDescribedType) {
        if (ruleDescribedType == null) {
            return null;
        }
        if (!ruleDescribedType.getDescriptor().equals(ClientConstants.RULE_DESCRIPTION_DESCRIPTOR)) {
            return null;
        }
        RuleDescription ruleDescription = new RuleDescription();
        if (ruleDescribedType.getDescribed() instanceof ArrayList) {
            ArrayList describedRule = (ArrayList)ruleDescribedType.getDescribed();
            int count = describedRule.size();
            if (count-- > 0) {
                ruleDescription.setFilter(RequestResponseUtils.decodeFilter(describedRule.get(0)));
            }
            if (count-- > 0) {
                ruleDescription.setAction(RequestResponseUtils.decodeRuleAction(describedRule.get(1)));
            }
            if (count > 0) {
                ruleDescription.setName((String)describedRule.get(2));
            }
        }
        return ruleDescription;
    }

    private static Filter decodeFilter(Object describedFilterObject) {
        if (describedFilterObject != null && describedFilterObject instanceof DescribedType) {
            DescribedType describedFilter = (DescribedType)describedFilterObject;
            if (describedFilter.getDescriptor().equals(ClientConstants.SQL_FILTER_DESCRIPTOR)) {
                ArrayList describedSqlFilter = (ArrayList)describedFilter.getDescribed();
                if (describedSqlFilter.size() > 0) {
                    return new SqlFilter((String)describedSqlFilter.get(0));
                }
            } else {
                if (describedFilter.getDescriptor().equals(ClientConstants.CORRELATION_FILTER_DESCRIPTOR)) {
                    Object properties;
                    CorrelationFilter correlationFilter = new CorrelationFilter();
                    ArrayList describedCorrelationFilter = (ArrayList)describedFilter.getDescribed();
                    int countCorrelationFilter = describedCorrelationFilter.size();
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setCorrelationId((String)describedCorrelationFilter.get(0));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setMessageId((String)describedCorrelationFilter.get(1));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setTo((String)describedCorrelationFilter.get(2));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setReplyTo((String)describedCorrelationFilter.get(3));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setLabel((String)describedCorrelationFilter.get(4));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setSessionId((String)describedCorrelationFilter.get(5));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setReplyToSessionId((String)describedCorrelationFilter.get(6));
                    }
                    if (countCorrelationFilter-- > 0) {
                        correlationFilter.setContentType((String)describedCorrelationFilter.get(7));
                    }
                    if (countCorrelationFilter > 0 && (properties = describedCorrelationFilter.get(8)) != null && properties instanceof Map) {
                        correlationFilter.setProperties((Map)properties);
                    }
                    return correlationFilter;
                }
                if (describedFilter.getDescriptor().equals(ClientConstants.TRUE_FILTER_DESCRIPTOR)) {
                    return new TrueFilter();
                }
                if (describedFilter.getDescriptor().equals(ClientConstants.FALSE_FILTER_DESCRIPTOR)) {
                    return new FalseFilter();
                }
                throw new UnsupportedOperationException("This client doesn't support filter with descriptor: " + describedFilter.getDescriptor());
            }
        }
        return null;
    }

    private static RuleAction decodeRuleAction(Object describedActionObject) {
        if (describedActionObject != null && describedActionObject instanceof DescribedType) {
            ArrayList describedSqlAction;
            DescribedType describedAction = (DescribedType)describedActionObject;
            if (describedAction.getDescriptor().equals(ClientConstants.EMPTY_RULE_ACTION_DESCRIPTOR)) {
                return null;
            }
            if (describedAction.getDescriptor().equals(ClientConstants.SQL_RULE_ACTION_DESCRIPTOR) && (describedSqlAction = (ArrayList)describedAction.getDescribed()).size() > 0) {
                return new SqlRuleAction((String)describedSqlAction.get(0));
            }
        }
        return null;
    }
}

