/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.aad.msal4j.MsalServiceException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class AADAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private AuthenticationFailureHandler defaultHandler = new SimpleUrlAuthenticationFailureHandler("/login?error");

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        Throwable cause;
        OAuth2AuthenticationException targetException = (OAuth2AuthenticationException)exception;
        if ("conditional_access_policy".equals(targetException.getError().getErrorCode()) && (cause = targetException.getCause()) instanceof MsalServiceException) {
            MsalServiceException e = (MsalServiceException)cause;
            String claims = e.claims();
            DefaultSavedRequest savedRequest = (DefaultSavedRequest)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST");
            String savedRequestUrl = savedRequest.getRedirectUrl();
            request.getSession().setAttribute("CAP_Claims", (Object)claims);
            response.setStatus(302);
            response.sendRedirect(savedRequestUrl);
            return;
        }
        this.defaultHandler.onAuthenticationFailure(request, response, exception);
    }
}

