/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.cosmosdb;

import com.azure.data.cosmos.ConnectionPolicy;
import com.azure.data.cosmos.CosmosClient;
import com.microsoft.azure.spring.autoconfigure.cosmosdb.CosmosDBProperties;
import com.microsoft.azure.spring.data.cosmosdb.config.AbstractCosmosConfiguration;
import com.microsoft.azure.spring.data.cosmosdb.config.CosmosDBConfig;
import com.microsoft.azure.spring.data.cosmosdb.core.CosmosTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CosmosClient.class, CosmosTemplate.class})
@ConditionalOnResource(resources={"classpath:cosmosdb.enable.config"})
@EnableConfigurationProperties(value={CosmosDBProperties.class})
public class CosmosAutoConfiguration
extends AbstractCosmosConfiguration {
    private final CosmosDBProperties properties;
    private final ConnectionPolicy policy;

    public CosmosAutoConfiguration(CosmosDBProperties properties, ObjectProvider<ConnectionPolicy> connectionPolicyObjectProvider) {
        this.properties = properties;
        this.policy = (ConnectionPolicy)connectionPolicyObjectProvider.getIfAvailable();
        this.configConnectionPolicy(properties, this.policy);
    }

    @Bean
    public CosmosDBConfig cosmosDBConfig() {
        return CosmosDBConfig.builder((String)this.properties.getUri(), (String)this.properties.getKey(), (String)this.properties.getDatabase()).consistencyLevel(this.properties.getConsistencyLevel()).allowTelemetry(this.properties.isAllowTelemetry()).connectionPolicy(this.properties.getConnectionPolicy()).responseDiagnosticsProcessor(this.properties.getResponseDiagnosticsProcessor()).populateQueryMetrics(this.properties.isPopulateQueryMetrics()).build();
    }

    private void configConnectionPolicy(CosmosDBProperties properties, ConnectionPolicy connectionPolicy) {
        ConnectionPolicy policy = connectionPolicy == null ? ConnectionPolicy.defaultPolicy() : connectionPolicy;
        properties.setConnectionPolicy(policy);
    }
}

