/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.Constants;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobEncryptStream;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.BlobOutputStreamInternal;
import com.microsoft.azure.storage.blob.BlobRequest;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockEntryListSerializer;
import com.microsoft.azure.storage.blob.BlockListHandler;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.StreamMd5AndLength;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.xml.stream.XMLStreamException;

public final class CloudBlockBlob
extends CloudBlob {
    public CloudBlockBlob(URI blobAbsoluteUri) throws StorageException {
        this(new StorageUri(blobAbsoluteUri));
    }

    public CloudBlockBlob(StorageUri blobAbsoluteUri) throws StorageException {
        this(blobAbsoluteUri, (StorageCredentials)null);
    }

    public CloudBlockBlob(CloudBlockBlob otherBlob) {
        super(otherBlob);
    }

    public CloudBlockBlob(URI blobAbsoluteUri, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(blobAbsoluteUri), credentials);
    }

    public CloudBlockBlob(StorageUri blobAbsoluteUri, StorageCredentials credentials) throws StorageException {
        this(blobAbsoluteUri, null, credentials);
    }

    public CloudBlockBlob(URI blobAbsoluteUri, String snapshotID, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(blobAbsoluteUri), snapshotID, credentials);
    }

    public CloudBlockBlob(StorageUri blobAbsoluteUri, String snapshotID, StorageCredentials credentials) throws StorageException {
        super(BlobType.BLOCK_BLOB, blobAbsoluteUri, snapshotID, credentials);
    }

    protected CloudBlockBlob(String blobName, String snapshotID, CloudBlobContainer container) throws URISyntaxException {
        super(BlobType.BLOCK_BLOB, blobName, snapshotID, container);
    }

    @DoesServiceRequest
    public final String startCopy(CloudBlockBlob sourceBlob) throws StorageException, URISyntaxException {
        return this.startCopy(sourceBlob, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(CloudBlockBlob sourceBlob, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceBlob", sourceBlob);
        return this.startCopy(sourceBlob.getQualifiedUri(), sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final String startCopy(CloudFile sourceFile) throws StorageException, URISyntaxException {
        return this.startCopy(sourceFile, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(CloudFile sourceFile, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceFile", sourceFile);
        return this.startCopy(sourceFile.getServiceClient().getCredentials().transformUri(sourceFile.getUri()), sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void commitBlockList(Iterable<BlockEntry> blockList) throws StorageException {
        this.commitBlockList(blockList, null, null, null);
    }

    @DoesServiceRequest
    public void commitBlockList(Iterable<BlockEntry> blockList, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.commitBlockListImpl(blockList, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> commitBlockListImpl(Iterable<BlockEntry> blockList, final AccessCondition accessCondition, final BlobRequestOptions options, OperationContext opContext) throws StorageException {
        try {
            byte[] blockListBytes = BlockEntryListSerializer.writeBlockListToStream(blockList, opContext);
            final ByteArrayInputStream blockListInputStream = new ByteArrayInputStream(blockListBytes);
            final StreamMd5AndLength descriptor = Utility.analyzeStream(blockListInputStream, -1L, -1L, true, options.getUseTransactionalContentMD5());
            StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                    this.setSendStream(blockListInputStream);
                    this.setLength(descriptor.getLength());
                    return BlobRequest.putBlockList(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.properties);
                }

                @Override
                public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                    BlobRequest.addMetadata(connection, blob.metadata, context);
                    if (options.getUseTransactionalContentMD5().booleanValue()) {
                        connection.setRequestProperty("Content-MD5", descriptor.getMd5());
                    }
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, this.getLength(), context);
                }

                @Override
                public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 201) {
                        this.setNonExceptionedRetryableFailure(true);
                        return null;
                    }
                    blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                    this.getResult().setRequestServiceEncrypted(CloudBlob.isServerRequestEncrypted(this.getConnection()));
                    return null;
                }

                @Override
                public void recoveryAction(OperationContext context) throws IOException {
                    blockListInputStream.reset();
                    blockListInputStream.mark(0x4000000);
                }
            };
            return putRequest;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
    }

    @DoesServiceRequest
    public ArrayList<BlockEntry> downloadBlockList() throws StorageException {
        return this.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
    }

    @DoesServiceRequest
    public ArrayList<BlockEntry> downloadBlockList(BlockListingFilter blockListingFilter, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("blockListingFilter", (Object)blockListingFilter);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadBlockListImpl(blockListingFilter, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>> downloadBlockListImpl(final BlockListingFilter blockListingFilter, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getBlockList(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID, blockListingFilter);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ArrayList<BlockEntry> preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ArrayList<BlockEntry> postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, ArrayList<BlockEntry> storageObject) throws Exception {
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateLengthFromResponse(this.getConnection());
                return BlockListHandler.getBlockList(this.getConnection().getInputStream());
            }
        };
        return getRequest;
    }

    public BlobOutputStream openOutputStream() throws StorageException {
        return this.openOutputStream(null, null, null);
    }

    public BlobOutputStream openOutputStream(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.assertNoWriteOperationForSnapshot();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient, false);
        options.assertPolicyIfRequired();
        if (options.getEncryptionPolicy() != null) {
            Cipher cipher = options.getEncryptionPolicy().createAndSetEncryptionContext(this.getMetadata(), false);
            return new BlobEncryptStream(this, accessCondition, options, opContext, cipher);
        }
        return new BlobOutputStreamInternal(this, accessCondition, options, opContext);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException {
        this.upload(sourceStream, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        boolean skipPutBlob;
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unknown length stream, or a positive number of bytes.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        options.assertPolicyIfRequired();
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        InputStream inputDataStream = sourceStream;
        boolean bl = skipPutBlob = !inputDataStream.markSupported() || descriptor.getLength() > (long)options.getSingleBlobPutThresholdInBytes().intValue();
        if (inputDataStream.markSupported()) {
            inputDataStream.mark(0x4000000);
        }
        if (!skipPutBlob && options.getEncryptionPolicy() != null) {
            class GettableByteArrayOutputStream
            extends ByteArrayOutputStream {
                GettableByteArrayOutputStream() {
                }

                public byte[] getByteArray() {
                    return this.buf;
                }
            }
            GettableByteArrayOutputStream targetStream = new GettableByteArrayOutputStream();
            Cipher cipher = options.getEncryptionPolicy().createAndSetEncryptionContext(this.getMetadata(), false);
            long byteCount = Utility.encryptStreamIfUnderThreshold(inputDataStream, targetStream, cipher, descriptor.getLength(), options.getSingleBlobPutThresholdInBytes() + 1);
            if (byteCount >= 0L) {
                inputDataStream = new ByteArrayInputStream(targetStream.getByteArray());
                descriptor.setLength(byteCount);
            } else {
                skipPutBlob = true;
            }
        }
        if (!skipPutBlob && (descriptor.getLength() < 0L || options.getStoreBlobContentMD5().booleanValue())) {
            if ((descriptor = Utility.analyzeStream(inputDataStream, descriptor.getLength(), options.getSingleBlobPutThresholdInBytes() + 1, true, options.getStoreBlobContentMD5())).getMd5() != null && options.getStoreBlobContentMD5().booleanValue()) {
                this.properties.setContentMD5(descriptor.getMd5());
            }
            if (descriptor.getLength() == -1L || descriptor.getLength() > (long)options.getSingleBlobPutThresholdInBytes().intValue()) {
                skipPutBlob = true;
            }
        }
        if (!skipPutBlob) {
            this.uploadFullBlob(inputDataStream, descriptor.getLength(), accessCondition, options, opContext);
        } else {
            BlobOutputStream writeStream = this.openOutputStream(accessCondition, options, opContext);
            try {
                writeStream.write(inputDataStream, length);
            }
            finally {
                writeStream.close();
            }
        }
    }

    @DoesServiceRequest
    protected final void uploadFullBlob(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        sourceStream.mark(0x4000000);
        if (length < 0L || length > 0x4000000L) {
            throw new IllegalArgumentException(String.format("Invalid stream length; stream must be between 0 and %s MB in length.", 64));
        }
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadFullBlobImpl(sourceStream, length, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadFullBlobImpl(final InputStream sourceStream, final long length, final AccessCondition accessCondition, final BlobRequestOptions options, final OperationContext opContext) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                this.setSendStream(sourceStream);
                this.setLength(length);
                return BlobRequest.putBlob(blob.getTransformedAddress(opContext).getUri(this.getCurrentLocation()), options, opContext, accessCondition, blob.properties, blob.properties.getBlobType(), this.getLength());
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, opContext);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, length, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(CloudBlob.isServerRequestEncrypted(this.getConnection()));
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                sourceStream.reset();
                sourceStream.mark(0x4000000);
            }

            @Override
            public void validateStreamWrite(StreamMd5AndLength descriptor) throws StorageException {
                if (this.getLength() != null && this.getLength() != -1L && length != descriptor.getLength()) {
                    throw new StorageException("InvalidInput", "An incorrect stream length was specified, resulting in an authentication failure. Please specify correct length, or -1.", 403, null, null);
                }
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void uploadBlock(String blockId, InputStream sourceStream, long length) throws StorageException, IOException {
        this.uploadBlock(blockId, sourceStream, length, null, null, null);
    }

    @DoesServiceRequest
    public void uploadBlock(String blockId, InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unknown length stream, or a positive number of bytes.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        options.assertNoEncryptionPolicyOrStrictMode();
        if (Utility.isNullOrEmpty(blockId) || !Base64.validateIsBase64String(blockId)) {
            throw new IllegalArgumentException("Invalid blockID, blockID must be a valid Base64 String.");
        }
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        InputStream bufferedStreamReference = sourceStream;
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        if (!sourceStream.markSupported()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            descriptor = Utility.writeToOutputStream(sourceStream, byteStream, length, false, options.getUseTransactionalContentMD5(), opContext, options);
            bufferedStreamReference = new ByteArrayInputStream(byteStream.toByteArray());
        } else if (length < 0L || options.getUseTransactionalContentMD5().booleanValue()) {
            descriptor = Utility.analyzeStream(sourceStream, length, -1L, true, options.getUseTransactionalContentMD5());
        }
        if (descriptor.getLength() > 0x400000L) {
            throw new IllegalArgumentException("Invalid stream length, length must be less than or equal to 4 MB in size.");
        }
        this.uploadBlockInternal(blockId, descriptor.getMd5(), bufferedStreamReference, descriptor.getLength(), accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private void uploadBlockInternal(String blockId, String md5, InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadBlockImpl(blockId, md5, sourceStream, length, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadBlockImpl(final String blockId, final String md5, final InputStream sourceStream, final long length, final AccessCondition accessCondition, final BlobRequestOptions options, final OperationContext opContext) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                this.setSendStream(sourceStream);
                this.setLength(length);
                return BlobRequest.putBlock(blob.getTransformedAddress(opContext).getUri(this.getCurrentLocation()), options, opContext, accessCondition, blockId);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                if (options.getUseTransactionalContentMD5().booleanValue()) {
                    connection.setRequestProperty("Content-MD5", md5);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, length, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                this.getResult().setRequestServiceEncrypted(CloudBlob.isServerRequestEncrypted(this.getConnection()));
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                sourceStream.reset();
                sourceStream.mark(0x4000000);
            }
        };
        return putRequest;
    }

    public void uploadText(String content) throws StorageException, IOException {
        this.uploadText(content, null, null, null, null);
    }

    public void uploadText(String content, String charsetName, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        byte[] bytes = charsetName == null ? content.getBytes() : content.getBytes(charsetName);
        this.uploadFromByteArray(bytes, 0, bytes.length, accessCondition, options, opContext);
    }

    public String downloadText() throws StorageException, IOException {
        return this.downloadText(null, null, null, null);
    }

    public String downloadText(String charsetName, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.download(baos, accessCondition, options, opContext);
        return charsetName == null ? baos.toString() : baos.toString(charsetName);
    }

    @Override
    public void setStreamWriteSizeInBytes(int streamWriteSizeInBytes) {
        if (streamWriteSizeInBytes > Constants.MAX_BLOCK_SIZE || streamWriteSizeInBytes < 16384) {
            throw new IllegalArgumentException("StreamWriteSizeInBytes");
        }
        this.streamWriteSizeInBytes = streamWriteSizeInBytes;
    }
}

