/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.ManagementCertificateOperations;
import com.microsoft.windowsazure.management.ManagementClientImpl;
import com.microsoft.windowsazure.management.models.ManagementCertificateCreateParameters;
import com.microsoft.windowsazure.management.models.ManagementCertificateGetResponse;
import com.microsoft.windowsazure.management.models.ManagementCertificateListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ManagementCertificateOperationsImpl
implements ServiceOperations<ManagementClientImpl>,
ManagementCertificateOperations {
    private ManagementClientImpl client;

    ManagementCertificateOperationsImpl(ManagementClientImpl client) {
        this.client = client;
    }

    public ManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> createAsync(final ManagementCertificateCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ManagementCertificateOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse create(ManagementCertificateCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ManagementCertificateCreateParameters> tracingParameters = new HashMap<String, ManagementCertificateCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/certificates";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element subscriptionCertificateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubscriptionCertificate");
        requestDoc.appendChild(subscriptionCertificateElement);
        if (parameters.getPublicKey() != null) {
            Element subscriptionCertificatePublicKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubscriptionCertificatePublicKey");
            subscriptionCertificatePublicKeyElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPublicKey())));
            subscriptionCertificateElement.appendChild(subscriptionCertificatePublicKeyElement);
        }
        if (parameters.getThumbprint() != null) {
            Element subscriptionCertificateThumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubscriptionCertificateThumbprint");
            subscriptionCertificateThumbprintElement.appendChild(requestDoc.createTextNode(parameters.getThumbprint()));
            subscriptionCertificateElement.appendChild(subscriptionCertificateThumbprintElement);
        }
        if (parameters.getData() != null) {
            Element subscriptionCertificateDataElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SubscriptionCertificateData");
            subscriptionCertificateDataElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getData())));
            subscriptionCertificateElement.appendChild(subscriptionCertificateDataElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String thumbprint) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ManagementCertificateOperationsImpl.this.delete(thumbprint);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String thumbprint) throws IOException, ServiceException {
        if (thumbprint == null) {
            throw new NullPointerException("thumbprint");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("thumbprint", thumbprint);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/certificates/";
        url = url + URLEncoder.encode(thumbprint, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 404) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ManagementCertificateGetResponse> getAsync(final String thumbprint) {
        return this.getClient().getExecutorService().submit(new Callable<ManagementCertificateGetResponse>(){

            @Override
            public ManagementCertificateGetResponse call() throws Exception {
                return ManagementCertificateOperationsImpl.this.get(thumbprint);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagementCertificateGetResponse get(String thumbprint) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (thumbprint == null) {
            throw new NullPointerException("thumbprint");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("thumbprint", thumbprint);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/certificates/";
        url = url + URLEncoder.encode(thumbprint, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ManagementCertificateGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementCertificateGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element subscriptionCertificateElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificate");
                if (subscriptionCertificateElement != null) {
                    Element createdElement;
                    Element subscriptionCertificateDataElement;
                    Element subscriptionCertificateThumbprintElement;
                    Element subscriptionCertificatePublicKeyElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificateElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificatePublicKey");
                    if (subscriptionCertificatePublicKeyElement != null) {
                        byte[] subscriptionCertificatePublicKeyInstance = subscriptionCertificatePublicKeyElement.getTextContent() != null ? Base64.decode((String)subscriptionCertificatePublicKeyElement.getTextContent()) : null;
                        result.setPublicKey(subscriptionCertificatePublicKeyInstance);
                    }
                    if ((subscriptionCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificateElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificateThumbprint")) != null) {
                        String subscriptionCertificateThumbprintInstance = subscriptionCertificateThumbprintElement.getTextContent();
                        result.setThumbprint(subscriptionCertificateThumbprintInstance);
                    }
                    if ((subscriptionCertificateDataElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificateElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificateData")) != null) {
                        byte[] subscriptionCertificateDataInstance = subscriptionCertificateDataElement.getTextContent() != null ? Base64.decode((String)subscriptionCertificateDataElement.getTextContent()) : null;
                        result.setData(subscriptionCertificateDataInstance);
                    }
                    if ((createdElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificateElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Created")) != null) {
                        Calendar createdInstance = DatatypeConverter.parseDateTime((String)createdElement.getTextContent());
                        result.setCreated(createdInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ManagementCertificateGetResponse managementCertificateGetResponse = result;
            return managementCertificateGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ManagementCertificateListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ManagementCertificateListResponse>(){

            @Override
            public ManagementCertificateListResponse call() throws Exception {
                return ManagementCertificateOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagementCertificateListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/certificates";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ManagementCertificateListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ManagementCertificateListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element subscriptionCertificatesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificates");
                if (subscriptionCertificatesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)subscriptionCertificatesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificate").size(); ++i1) {
                        Element createdElement;
                        Element subscriptionCertificateDataElement;
                        Element subscriptionCertificateThumbprintElement;
                        Element subscriptionCertificatesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subscriptionCertificatesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificate").get(i1);
                        ManagementCertificateListResponse.SubscriptionCertificate subscriptionCertificateInstance = new ManagementCertificateListResponse.SubscriptionCertificate();
                        result.getSubscriptionCertificates().add(subscriptionCertificateInstance);
                        Element subscriptionCertificatePublicKeyElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificatesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificatePublicKey");
                        if (subscriptionCertificatePublicKeyElement != null) {
                            byte[] subscriptionCertificatePublicKeyInstance = subscriptionCertificatePublicKeyElement.getTextContent() != null ? Base64.decode((String)subscriptionCertificatePublicKeyElement.getTextContent()) : null;
                            subscriptionCertificateInstance.setPublicKey(subscriptionCertificatePublicKeyInstance);
                        }
                        if ((subscriptionCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificatesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificateThumbprint")) != null) {
                            String subscriptionCertificateThumbprintInstance = subscriptionCertificateThumbprintElement.getTextContent();
                            subscriptionCertificateInstance.setThumbprint(subscriptionCertificateThumbprintInstance);
                        }
                        if ((subscriptionCertificateDataElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificatesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubscriptionCertificateData")) != null) {
                            byte[] subscriptionCertificateDataInstance = subscriptionCertificateDataElement.getTextContent() != null ? Base64.decode((String)subscriptionCertificateDataElement.getTextContent()) : null;
                            subscriptionCertificateInstance.setData(subscriptionCertificateDataInstance);
                        }
                        if ((createdElement = XmlUtility.getElementByTagNameNS((Node)subscriptionCertificatesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Created")) == null) continue;
                        Calendar createdInstance = DatatypeConverter.parseDateTime((String)createdElement.getTextContent());
                        subscriptionCertificateInstance.setCreated(createdInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            ManagementCertificateListResponse managementCertificateListResponse = result;
            return managementCertificateListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

