/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Operation<T> {
    public static final String UNKNOWN_NAME = "<unknown>.<unknown>";

    @Nonnull
    public String getExecutionId();

    @Nonnull
    default public String getName() {
        return Optional.ofNullable(this.getTitle()).map(AzureString::getName).orElse(UNKNOWN_NAME);
    }

    public Callable<T> getBody();

    @Nonnull
    public String getType();

    @Nullable
    public AzureString getTitle();

    public void setParent(Operation<?> var1);

    @Nullable
    public Operation<?> getParent();

    public OperationContext getContext();

    default public Operation<?> getEffectiveParent() {
        Operation<?> parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.getName().equals(UNKNOWN_NAME)) {
            return parent;
        }
        return parent.getEffectiveParent();
    }

    @Nullable
    default public Operation<?> getActionParent() {
        if (this.getType().equals(AzureOperation.Type.ACTION.name())) {
            return this;
        }
        return Optional.ofNullable(this.getParent()).map(Operation::getActionParent).orElse(null);
    }

    @Nullable
    public static Operation<?> current() {
        return OperationThreadContext.current().currentOperation();
    }
}

