/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureResources
extends AbstractAzService<ResourcesServiceSubscription, ResourceManager> {
    private static final Logger log = LoggerFactory.getLogger(AzureResources.class);

    public AzureResources() {
        super("Microsoft.Resources");
    }

    @Nonnull
    public ResourceGroupModule groups(@Nonnull String subscriptionId) {
        ResourcesServiceSubscription rm = (ResourcesServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getGroupModule();
    }

    @Nullable
    public GenericResource getGenericResource(@Nonnull String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        String rgName = id.resourceGroupName();
        ResourceGroup rg = (ResourceGroup)this.groups(id.subscriptionId()).get(rgName, rgName);
        return Optional.ofNullable(rg).map(ResourceGroup::genericResources).map(r -> (GenericResource)r.get(resourceId, rgName)).orElse(null);
    }

    @Override
    @Nonnull
    protected ResourceManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        return AbstractAzServiceSubscription.getResourceManager(subscriptionId);
    }

    @Override
    @Nonnull
    protected ResourcesServiceSubscription newResource(@Nonnull ResourceManager remote) {
        return new ResourcesServiceSubscription(remote, this);
    }

    @Override
    @Nullable
    public <E> E getById(@Nonnull String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        String resourceGroup = resourceId.resourceGroupName();
        String type = resourceId.resourceType();
        ResourcesServiceSubscription subscription = Objects.requireNonNull((ResourcesServiceSubscription)this.getOrDraft(resourceId.subscriptionId(), resourceGroup));
        if (type.equals("subscriptions")) {
            return (E)subscription;
        }
        ResourceGroup group = (ResourceGroup)subscription.resourceGroups().getOrDraft(resourceGroup, resourceGroup);
        if (type.equals("resourceGroups")) {
            return (E)group;
        }
        if (type.equals("deployments")) {
            return (E)group.deployments().getOrDraft(resourceId.name(), resourceGroup);
        }
        return (E)group.genericResources().get(id, resourceGroup);
    }

    @Override
    @Nullable
    public <E> E getOrInitById(@Nonnull String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        String resourceGroup = resourceId.resourceGroupName();
        String type = resourceId.resourceType();
        ResourcesServiceSubscription subscription = Objects.requireNonNull((ResourcesServiceSubscription)this.get(resourceId.subscriptionId(), resourceGroup));
        if (type.equals("subscriptions")) {
            return (E)subscription;
        }
        ResourceGroup group = (ResourceGroup)subscription.resourceGroups().get(resourceGroup, resourceGroup);
        if (type.equals("resourceGroups")) {
            return (E)group;
        }
        if (type.equals("deployments")) {
            return (E)group.deployments().getOrInit(resourceId.name(), resourceGroup);
        }
        return (E)group.genericResources().getOrInit(id, resourceGroup);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Resource groups";
    }
}

