/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.models.Registries;
import com.azure.resourcemanager.containerregistry.models.Registry;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureContainerRegistryModule
extends AbstractAzResourceModule<ContainerRegistry, AzureContainerRegistryServiceSubscription, Registry> {
    public static final String NAME = "registries";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AzureContainerRegistryModule(@Nonnull AzureContainerRegistryServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, Registry>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.list().iterableByPage(AzureContainerRegistryModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    protected Registry loadResourceFromAzure(@Nonnull String name, String resourceGroup) {
        return Optional.ofNullable(this.getClient()).map(client -> (Registry)client.getByResourceGroup(resourceGroup, name)).orElse(null);
    }

    @AzureOperation(name="azure/container.delete_registry.registry", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional.ofNullable(this.getClient()).ifPresent(client -> client.deleteById(resourceId));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected ContainerRegistry newResource(@Nonnull Registry registry) {
        return new ContainerRegistry(registry, this);
    }

    @Nonnull
    protected ContainerRegistry newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ContainerRegistry(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    protected ContainerRegistryDraft newDraftForCreate(@Nonnull String name, String resourceGroup) {
        return new ContainerRegistryDraft(name, resourceGroup, this);
    }

    @Nonnull
    protected ContainerRegistryDraft newDraftForUpdate(@Nonnull ContainerRegistry origin) {
        return new ContainerRegistryDraft(origin);
    }

    public Registries getClient() {
        return Optional.ofNullable((ContainerRegistryManager)((AzureContainerRegistryServiceSubscription)this.parent).getRemote()).map(ContainerRegistryManager::containerRegistries).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Container Registry";
    }

    static {
        AzureContainerRegistryModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureContainerRegistryModule.java", AzureContainerRegistryModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule", "java.lang.String", "resourceId", "", "void"), 45);
    }
}

