/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureResources
extends AbstractAzService<ResourceGroupManager, ResourceManager> {
    private static final Logger log = LoggerFactory.getLogger(AzureResources.class);

    public AzureResources() {
        super("Microsoft.Resources");
    }

    @Nonnull
    public ResourceGroupModule groups(@Nonnull String subscriptionId) {
        ResourceGroupManager rm = (ResourceGroupManager)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getGroupModule();
    }

    @Nonnull
    protected ResourceManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        return AbstractAzResourceManager.getResourceManager((String)subscriptionId);
    }

    protected ResourceGroupManager newResource(@Nonnull ResourceManager remote) {
        return new ResourceGroupManager(remote, this);
    }

    public String getResourceTypeName() {
        return "Resource groups";
    }
}

