/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ResourceGroupModule
extends AbstractAzResourceModule<ResourceGroup, ResourceGroupManager, com.azure.resourcemanager.resources.models.ResourceGroup> {
    public static final String NAME = "resourceGroups";

    public ResourceGroupModule(@Nonnull ResourceGroupManager parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    @AzureOperation(name="group.create.rg", params={"name"}, type=AzureOperation.Type.SERVICE)
    public com.microsoft.azure.toolkit.lib.common.model.ResourceGroup createResourceGroupIfNotExist(String name, Region region) {
        ResourceGroup group = (ResourceGroup)this.getOrDraft(name, name);
        if (group instanceof ResourceGroupDraft && !group.exists()) {
            ((ResourceGroupDraft)group).setRegion(region);
            return ((ResourceGroup)((ResourceGroupDraft)group).createIfNotExist()).toPojo();
        }
        return group.toPojo();
    }

    @Nullable
    public ResourceGroups getClient() {
        return Optional.ofNullable((ResourceManager)((ResourceGroupManager)this.parent).getRemote()).map(ResourceManager::resourceGroups).orElse(null);
    }

    public boolean exists(String resourceName) {
        return Optional.ofNullable(this.getClient()).map(c -> c.contain(resourceName)).orElse(false);
    }

    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ResourceGroupDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        AzureTelemetry.getContext().setProperty("resourceType", this.getFullResourceType());
        AzureTelemetry.getContext().setProperty("subscriptionId", this.getSubscriptionId());
        return new ResourceGroupDraft(name, resourceGroupName, this);
    }

    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ResourceGroupDraft newDraftForUpdate(@Nonnull ResourceGroup origin) {
        AzureTelemetry.getContext().setProperty("resourceType", this.getFullResourceType());
        AzureTelemetry.getContext().setProperty("subscriptionId", this.getSubscriptionId());
        return new ResourceGroupDraft(origin);
    }

    @Nonnull
    public String toResourceId(@Nonnull String resourceName, String resourceGroup) {
        assert (StringUtils.equalsAny((CharSequence)resourceGroup, (CharSequence[])new CharSequence[]{resourceName, null}));
        return String.format("/subscriptions/%s/resourceGroups/%s", this.getSubscriptionId(), resourceName);
    }

    @Nonnull
    protected ResourceGroup newResource(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup r) {
        return new ResourceGroup(r, this);
    }

    public String getResourceTypeName() {
        return "Resource group";
    }
}

