/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudServiceSubscription;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class AzureSpringCloud
extends AbstractAzService<SpringCloudServiceSubscription, AppPlatformManager> {
    public AzureSpringCloud() {
        super("Microsoft.AppPlatform");
    }

    @Nonnull
    public SpringCloudClusterModule clusters(@Nonnull String subscriptionId) {
        SpringCloudServiceSubscription rm = (SpringCloudServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getClusterModule();
    }

    @Nonnull
    protected AppPlatformManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(null, subscriptionId, account.getEnvironment());
        return ((AppPlatformManager.Configurable)((AppPlatformManager.Configurable)((AppPlatformManager.Configurable)AppPlatformManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withLogLevel(logLevel)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    protected SpringCloudServiceSubscription newResource(@Nonnull AppPlatformManager remote) {
        return new SpringCloudServiceSubscription(remote, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Azure Spring Apps";
    }
}

