/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentDraft;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudAppConfig;
import com.microsoft.azure.toolkit.lib.springcloud.config.SpringCloudDeploymentConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SpringCloudAppDraft
extends SpringCloudApp
implements AzResource.Draft<SpringCloudApp, SpringApp> {
    private static final String UPDATE_APP_WARNING = "It may take some moments for the configuration to be applied at server side!";
    public static final String DEFAULT_DISK_MOUNT_PATH = "/persistent";
    public static final String DEFAULT_DEPLOYMENT_NAME = "default";
    public static final int BASIC_TIER_DEFAULT_DISK_SIZE = 1;
    public static final int STANDARD_TIER_DEFAULT_DISK_SIZE = 50;
    @Nullable
    private final SpringCloudApp origin;
    @Nullable
    private SpringCloudDeployment activeDeployment;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    SpringCloudAppDraft(@Nonnull String name, @Nonnull SpringCloudAppModule module) {
        super(name, module);
        this.origin = null;
    }

    SpringCloudAppDraft(@Nonnull SpringCloudApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void setConfig(@Nonnull SpringCloudAppConfig c) {
        this.setName(c.getAppName());
        this.setActiveDeploymentName(c.getActiveDeploymentName());
        this.setPublicEndpointEnabled(c.getIsPublic());
        SpringCloudDeploymentConfig deploymentConfig = c.getDeployment();
        SpringCloudDeploymentDraft deploymentDraft = this.updateOrCreateActiveDeployment();
        this.setPersistentDiskEnabled(deploymentConfig.getEnablePersistentStorage());
        deploymentDraft.setConfig(deploymentConfig);
    }

    @Nonnull
    public SpringCloudAppConfig getConfig() {
        SpringCloudDeploymentConfig deploymentConfig = this.activeDeployment instanceof SpringCloudDeploymentDraft ? ((SpringCloudDeploymentDraft)this.activeDeployment).getConfig() : SpringCloudDeploymentConfig.builder().build();
        deploymentConfig.setEnablePersistentStorage(this.isPersistentDiskEnabled());
        return SpringCloudAppConfig.builder().subscriptionId(this.getSubscriptionId()).clusterName(((SpringCloudCluster)this.getParent()).getName()).appName(this.getName()).resourceGroup(this.getResourceGroupName()).isPublic(this.isPublicEndpointEnabled()).activeDeploymentName(this.getActiveDeploymentName()).deployment(deploymentConfig).build();
    }

    public void reset() {
        this.config = null;
        if (this.activeDeployment instanceof AzResource.Draft) {
            ((AzResource.Draft)this.activeDeployment).reset();
        }
        this.activeDeployment = null;
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.create_app.app", params={"this.getName()"})
    public SpringApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            SpringApp.DefinitionStages.WithCreate create;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String appName = this.getName();
            SpringService service = Objects.requireNonNull((SpringService)((SpringCloudCluster)this.getParent()).getRemote(new boolean[0]));
            SpringApp.DefinitionStages.Blank blank = (SpringApp.DefinitionStages.Blank)service.apps().define(appName);
            String newActiveDeploymentName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.getActiveDeploymentName(), DEFAULT_DEPLOYMENT_NAME});
            boolean newPublicEndpointEnabled = this.isPublicEndpointEnabled();
            boolean newPersistentDiskEnabled = this.isPersistentDiskEnabled();
            SpringApp.DefinitionStages.WithCreate withCreate = create = !Objects.equals(newActiveDeploymentName, DEFAULT_DEPLOYMENT_NAME) ? (SpringApp.DefinitionStages.WithCreate)((SpringAppDeployment.DefinitionStages.WithAttach)((SpringAppImpl)blank).withActiveDeployment(newActiveDeploymentName).defineActiveDeployment(newActiveDeploymentName).withExistingSource(UserSourceType.JAR, "<default>")).attach() : blank.withDefaultActiveDeployment();
            if (!Objects.equals(super.isPublicEndpointEnabled(), newPublicEndpointEnabled) && newPublicEndpointEnabled) {
                create = create.withDefaultPublicEndpoint();
            }
            if (!((SpringCloudCluster)this.getParent()).isEnterpriseTier() && !Objects.equals(super.isPersistentDiskEnabled(), newPersistentDiskEnabled)) {
                create = newPersistentDiskEnabled ? (((SpringCloudCluster)this.getParent()).getSku().toLowerCase().startsWith("s") ? create.withPersistentDisk(50, DEFAULT_DISK_MOUNT_PATH) : create.withPersistentDisk(1, DEFAULT_DISK_MOUNT_PATH)) : create.withPersistentDisk(0, null);
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating app({0})...", (Object[])new Object[]{appName}));
            SpringApp app = (SpringApp)create.create();
            messager.success(AzureString.format((String)"App({0}) is successfully created.", (Object[])new Object[]{appName}));
            SpringApp springApp = app;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/springcloud.update_app.app", params={"this.getName()"})
    public SpringApp updateResourceInAzure(@Nonnull SpringApp origin) {
        SpringApp springApp = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)springApp);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String oldActiveDeploymentName = super.getActiveDeploymentName();
            String newActiveDeploymentName = this.getActiveDeploymentName();
            boolean newPublicEndpointEnabled = this.isPublicEndpointEnabled();
            boolean newPersistentDiskEnabled = this.isPersistentDiskEnabled();
            boolean modified = !Objects.equals(oldActiveDeploymentName, newActiveDeploymentName) && StringUtils.isNotBlank((CharSequence)newActiveDeploymentName) || !Objects.equals(super.isPublicEndpointEnabled(), newPublicEndpointEnabled) || !((SpringCloudCluster)this.getParent()).isEnterpriseTier() && !Objects.equals(super.isPersistentDiskEnabled(), newPersistentDiskEnabled);
            SpringApp.Update update = (SpringApp.Update)origin.update();
            Optional.ofNullable(newActiveDeploymentName).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((SpringApp.Update)update).withActiveDeployment(arg_0));
            SpringApp.Update update2 = update = newPublicEndpointEnabled ? update.withDefaultPublicEndpoint() : update.withoutDefaultPublicEndpoint();
            SpringApp.Update update3 = newPersistentDiskEnabled ? (((SpringCloudCluster)this.getParent()).getSku().toLowerCase().startsWith("s") ? update.withPersistentDisk(50, DEFAULT_DISK_MOUNT_PATH) : update.withPersistentDisk(1, DEFAULT_DISK_MOUNT_PATH)) : (update = update.withPersistentDisk(0, null));
            if (modified) {
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating app({0})...", (Object[])new Object[]{origin.name()}));
                origin = (SpringApp)update.apply();
                messager.success(AzureString.format((String)"App({0}) is successfully updated.", (Object[])new Object[]{origin.name()}));
                messager.warning(UPDATE_APP_WARNING);
            }
            SpringApp springApp2 = origin;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return springApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setName(@Nonnull String name) {
        this.ensureConfig().setName(name);
    }

    @Nonnull
    public String getName() {
        return Optional.ofNullable(this.config).map(Config::getName).orElseGet(() -> super.getName());
    }

    public void setPublicEndpointEnabled(Boolean enabled) {
        this.ensureConfig().setPublicEndpointEnabled(enabled);
    }

    @Override
    public boolean isPublicEndpointEnabled() {
        return Optional.ofNullable(this.config).map(Config::getPublicEndpointEnabled).orElseGet(() -> super.isPublicEndpointEnabled());
    }

    public void setPersistentDiskEnabled(Boolean enabled) {
        this.ensureConfig().setPersistentDiskEnabled(enabled);
    }

    @Override
    public boolean isPersistentDiskEnabled() {
        return Optional.ofNullable(this.config).map(Config::getPersistentDiskEnabled).orElseGet(() -> super.isPersistentDiskEnabled());
    }

    public void setActiveDeploymentName(String name) {
        this.ensureConfig().setActiveDeploymentName(name);
    }

    @Override
    @Nullable
    public String getActiveDeploymentName() {
        return Optional.ofNullable(this.config).map(Config::getActiveDeploymentName).orElseGet(() -> super.getActiveDeploymentName());
    }

    @Override
    @Nullable
    public SpringCloudDeployment getActiveDeployment() {
        return Optional.ofNullable(this.activeDeployment).orElseGet(() -> super.getActiveDeployment());
    }

    @Nonnull
    public SpringCloudDeploymentDraft updateOrCreateActiveDeployment() {
        String activeDeploymentName = Optional.ofNullable(this.getActiveDeploymentName()).orElse(DEFAULT_DEPLOYMENT_NAME);
        SpringCloudDeploymentDraft deploymentDraft = (SpringCloudDeploymentDraft)Optional.ofNullable(super.getActiveDeployment()).map(AbstractAzResource::update).orElseGet(() -> this.deployments().updateOrCreate(activeDeploymentName, this.getResourceGroupName()));
        this.setActiveDeployment(deploymentDraft);
        return deploymentDraft;
    }

    public void setActiveDeployment(SpringCloudDeployment activeDeployment) {
        this.activeDeployment = activeDeployment;
        Optional.ofNullable(activeDeployment).map(AbstractAzResource::getName).ifPresent(this::setActiveDeploymentName);
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getName()) || Objects.equals(this.config.getName(), super.getName()) || Objects.isNull(this.config.getActiveDeploymentName()) || Objects.equals(this.config.getActiveDeploymentName(), super.getActiveDeploymentName()) || Objects.equals(this.isPublicEndpointEnabled(), super.isPublicEndpointEnabled()) || Objects.equals(this.isPersistentDiskEnabled(), super.isPersistentDiskEnabled()) || !(this.activeDeployment instanceof AzResource.Draft) || !((SpringCloudDeploymentDraft)this.activeDeployment).isModified();
        return !notModified;
    }

    @Nullable
    public SpringCloudApp getOrigin() {
        return this.origin;
    }

    static {
        SpringCloudAppDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudAppDraft.java", SpringCloudAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft", "", "", "", "com.azure.resourcemanager.appplatform.models.SpringApp"), 98);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppDraft", "com.azure.resourcemanager.appplatform.models.SpringApp", "origin", "", "com.azure.resourcemanager.appplatform.models.SpringApp"), 133);
    }

    private static class Config {
        private String name;
        @Nullable
        private String activeDeploymentName;
        @Nullable
        private Boolean publicEndpointEnabled;
        @Nullable
        private Boolean persistentDiskEnabled;

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getActiveDeploymentName() {
            return this.activeDeploymentName;
        }

        @Nullable
        public Boolean getPublicEndpointEnabled() {
            return this.publicEndpointEnabled;
        }

        @Nullable
        public Boolean getPersistentDiskEnabled() {
            return this.persistentDiskEnabled;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setActiveDeploymentName(@Nullable String activeDeploymentName) {
            this.activeDeploymentName = activeDeploymentName;
        }

        public void setPublicEndpointEnabled(@Nullable Boolean publicEndpointEnabled) {
            this.publicEndpointEnabled = publicEndpointEnabled;
        }

        public void setPersistentDiskEnabled(@Nullable Boolean persistentDiskEnabled) {
            this.persistentDiskEnabled = persistentDiskEnabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$publicEndpointEnabled = this.getPublicEndpointEnabled();
            Boolean other$publicEndpointEnabled = other.getPublicEndpointEnabled();
            if (this$publicEndpointEnabled == null ? other$publicEndpointEnabled != null : !((Object)this$publicEndpointEnabled).equals(other$publicEndpointEnabled)) {
                return false;
            }
            Boolean this$persistentDiskEnabled = this.getPersistentDiskEnabled();
            Boolean other$persistentDiskEnabled = other.getPersistentDiskEnabled();
            if (this$persistentDiskEnabled == null ? other$persistentDiskEnabled != null : !((Object)this$persistentDiskEnabled).equals(other$persistentDiskEnabled)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$activeDeploymentName = this.getActiveDeploymentName();
            String other$activeDeploymentName = other.getActiveDeploymentName();
            return !(this$activeDeploymentName == null ? other$activeDeploymentName != null : !this$activeDeploymentName.equals(other$activeDeploymentName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $publicEndpointEnabled = this.getPublicEndpointEnabled();
            result = result * 59 + ($publicEndpointEnabled == null ? 43 : ((Object)$publicEndpointEnabled).hashCode());
            Boolean $persistentDiskEnabled = this.getPersistentDiskEnabled();
            result = result * 59 + ($persistentDiskEnabled == null ? 43 : ((Object)$persistentDiskEnabled).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $activeDeploymentName = this.getActiveDeploymentName();
            result = result * 59 + ($activeDeploymentName == null ? 43 : $activeDeploymentName.hashCode());
            return result;
        }

        public String toString() {
            return "SpringCloudAppDraft.Config(name=" + this.getName() + ", activeDeploymentName=" + this.getActiveDeploymentName() + ", publicEndpointEnabled=" + this.getPublicEndpointEnabled() + ", persistentDiskEnabled=" + this.getPersistentDiskEnabled() + ")";
        }
    }
}

