/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstance;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCloudAppInstanceModule
extends AbstractAzResourceModule<SpringCloudAppInstance, SpringCloudDeployment, DeploymentInstance> {
    public static final String NAME = "instances";

    public SpringCloudAppInstanceModule(@NotNull SpringCloudDeployment parent) {
        super(NAME, (AzResource)parent);
    }

    @Nullable
    protected List<DeploymentInstance> getClient() {
        return Optional.ofNullable((SpringAppDeployment)((SpringCloudDeployment)this.parent).getRemote(new boolean[0])).map(SpringAppDeployment::instances).orElse(null);
    }

    @Nullable
    protected DeploymentInstance loadResourceFromAzure(@NotNull String name, @Nullable String resourceGroup) {
        List deploymentInstanceList = Optional.ofNullable(this.getClient()).orElse(Collections.emptyList());
        return deploymentInstanceList.stream().filter(instance -> name.equals(instance.name())).findAny().orElse(null);
    }

    protected Iterator<? extends ContinuablePage<String, DeploymentInstance>> loadResourcePagesFromAzure() {
        return Collections.singletonList(new ItemPage(this.loadResourcesFromAzure())).iterator();
    }

    @NotNull
    protected Stream<DeploymentInstance> loadResourcesFromAzure() {
        List deploymentInstanceList = Optional.ofNullable(this.getClient()).orElse(Collections.emptyList());
        return deploymentInstanceList.stream();
    }

    @NotNull
    protected SpringCloudAppInstance newResource(@NotNull DeploymentInstance deploymentInstance) {
        return new SpringCloudAppInstance(deploymentInstance, this);
    }

    @NotNull
    protected SpringCloudAppInstance newResource(@NotNull String name, @Nullable String resourceGroupName) {
        return new SpringCloudAppInstance(name, this);
    }

    @NotNull
    public String getResourceTypeName() {
        return "Spring App instance";
    }
}

