/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.RemoteDebuggingInner;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.RemoteDebuggingPayload;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.google.common.base.Charsets;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstance;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstanceModule;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeploymentModule;
import com.microsoft.azure.toolkit.lib.springcloud.Utils;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class SpringCloudDeployment
extends AbstractAzResource<SpringCloudDeployment, SpringCloudApp, SpringAppDeployment> {
    @Nonnull
    private final SpringCloudAppInstanceModule instanceModule;
    private boolean remoteDebuggingEnabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    protected SpringCloudDeployment(@Nonnull String name, @Nonnull SpringCloudDeploymentModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.instanceModule = new SpringCloudAppInstanceModule(this);
    }

    protected SpringCloudDeployment(@Nonnull SpringCloudDeployment origin) {
        super((AbstractAzResource)origin);
        this.instanceModule = origin.instanceModule;
        this.remoteDebuggingEnabled = origin.remoteDebuggingEnabled;
    }

    protected SpringCloudDeployment(@Nonnull SpringAppDeployment remote, @Nonnull SpringCloudDeploymentModule module) {
        super(remote.name(), (AbstractAzResourceModule)module);
        this.instanceModule = new SpringCloudAppInstanceModule(this);
    }

    @AzureOperation(name="azure/resource.start_resource.resource", params={"this.name()"})
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((SpringAppDeployment)this.getRemote(new boolean[0])).start(), "Starting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.stop_resource.resource", params={"this.name()"})
    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((SpringAppDeployment)this.getRemote(new boolean[0])).stop(), "Stopping");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.restart_resource.resource", params={"this.name()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> Objects.requireNonNull((SpringAppDeployment)this.getRemote(new boolean[0])).restart(), "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public String loadStatus(@Nonnull SpringAppDeployment remote) {
        return Optional.of(remote).map(SpringAppDeployment::status).map(ExpandableStringEnum::toString).orElse("Unknown");
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.instanceModule);
    }

    protected void updateAdditionalProperties(SpringAppDeployment newRemote, SpringAppDeployment oldRemote) {
        SpringCloudApp app = (SpringCloudApp)this.getParent();
        SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
        this.remoteDebuggingEnabled = Optional.ofNullable((SpringService)cluster.getRemote(new boolean[0])).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).map(c -> c.getRemoteDebuggingConfig(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName())).map(RemoteDebuggingInner::enabled).orElse(false);
    }

    @Nonnull
    public Flux<String> streamLogs(String instance) {
        return this.streamLogs(instance, 0, 10, 0, true);
    }

    @Nonnull
    public Flux<String> streamLogs(String instance, int sinceSeconds, int tailLines, int limitBytes, boolean follow) {
        HttpClient client = HttpClient.create().keepAlive(true);
        URIBuilder endpoint = new URIBuilder(((SpringCloudApp)this.getParent()).getLogStreamingEndpoint(instance));
        endpoint.addParameter("follow", String.valueOf(follow));
        if (sinceSeconds > 0) {
            endpoint.addParameter("sinceSeconds", String.valueOf(sinceSeconds));
        }
        if (tailLines > 0) {
            endpoint.addParameter("tailLines", String.valueOf(tailLines));
        }
        if (limitBytes > 0) {
            endpoint.addParameter("limitBytes", String.valueOf(limitBytes));
        }
        String password = ((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).getTestKey();
        String userPass = "primary:" + password;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userPass.getBytes()));
        Consumer<HttpHeaders> headerBuilder = header -> header.set("Authorization", (Object)basicAuth);
        return ((HttpClient.ResponseReceiver)client.headers(headerBuilder).responseTimeout(Duration.of(10L, ChronoUnit.MINUTES)).get().uri(endpoint.build())).response((resp, cont) -> resp.status().code() == 200 ? cont.asString(Charsets.UTF_8) : Mono.empty());
    }

    @AzureOperation(name="internal/springcloud.wait_until_deployment_ready.deployment|app", params={"this.getName()", "this.getParent().getName()"})
    public boolean waitUntilReady(int timeoutInSeconds) {
        int n = timeoutInSeconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureMessager.getMessager().info("Getting deployment status...");
            SpringCloudDeployment deployment = Utils.pollUntil(() -> {
                this.invalidateCache();
                return this;
            }, Utils::isDeploymentDone, timeoutInSeconds);
            boolean bl = Utils.isDeploymentDone(deployment);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public Double getCpu() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote(new boolean[0])).map(SpringAppDeployment::cpu).orElse(null);
    }

    @Nullable
    public Double getMemoryInGB() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote(new boolean[0])).map(SpringAppDeployment::memoryInGB).orElse(null);
    }

    @Nullable
    public String getRuntimeVersion() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote(new boolean[0])).map(SpringAppDeployment::runtimeVersion).map(ExpandableStringEnum::toString).orElse(null);
    }

    @Nullable
    public String getJvmOptions() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote(new boolean[0])).map(SpringAppDeployment::jvmOptions).orElse(null);
    }

    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote(new boolean[0])).map(SpringAppDeployment::settings).map(DeploymentSettings::environmentVariables).map(v -> {
            HashMap variables = new HashMap(v);
            if (((SpringCloudCluster)((SpringCloudApp)this.getParent()).getParent()).isEnterpriseTier() && StringUtils.isBlank((CharSequence)((CharSequence)variables.get("JAVA_OPTS")))) {
                variables.remove("JAVA_OPTS");
            }
            return variables;
        }).orElse(null);
    }

    public List<SpringCloudAppInstance> getInstances() {
        return this.instanceModule.list();
    }

    @Nullable
    public Integer getInstanceNum() {
        return this.remoteOptional(new boolean[0]).map(SpringAppDeployment::instances).map(List::size).orElse(null);
    }

    @Nonnull
    public Boolean isActive() {
        return Optional.ofNullable((SpringAppDeployment)this.getRemote(new boolean[0])).map(SpringAppDeployment::isActive).orElse(false);
    }

    public void setStatus(@Nonnull String status) {
        super.setStatus(status);
        if (this.isActive().booleanValue()) {
            ((SpringCloudApp)this.getParent()).reloadStatus();
        }
    }

    @AzureOperation(name="azure/springcloud.enable_remote_debugging.deployment", params={"this.getName()"})
    public void enableRemoteDebugging(int port) {
        int n = port;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringCloudApp app = (SpringCloudApp)this.getParent();
            SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
            RemoteDebuggingPayload payload = new RemoteDebuggingPayload().withPort(Integer.valueOf(port));
            Optional.ofNullable((SpringService)cluster.getRemote(new boolean[0])).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).ifPresent(c -> this.doModify(() -> c.enableRemoteDebugging(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName(), payload), "Updating"));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/springcloud.disable_remote_debugging.deployment", params={"this.getName()"})
    public void disableRemoteDebugging() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SpringCloudApp app = (SpringCloudApp)this.getParent();
            SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
            Optional.ofNullable((SpringService)cluster.getRemote(new boolean[0])).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).ifPresent(c -> this.doModify(() -> c.disableRemoteDebugging(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName()), "Updating"));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isRemoteDebuggingEnabled() {
        return this.remoteDebuggingEnabled;
    }

    public int getRemoteDebuggingPort() {
        SpringCloudApp app = (SpringCloudApp)this.getParent();
        SpringCloudCluster cluster = (SpringCloudCluster)app.getParent();
        return Optional.ofNullable((SpringService)cluster.getRemote(new boolean[0])).map(HasManager::manager).map(Manager::serviceClient).map(AppPlatformManagementClient::getDeployments).map(c -> c.getRemoteDebuggingConfig(this.getResourceGroupName(), cluster.getName(), app.getName(), this.getName())).map(RemoteDebuggingInner::port).orElseThrow(() -> new AzureToolkitRuntimeException("Failed to get remote debugging port."));
    }

    static {
        SpringCloudDeployment.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpringCloudDeployment.java", SpringCloudDeployment.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 76);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 81);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "waitUntilReady", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "int", "timeoutInSeconds", "", "boolean"), 145);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableRemoteDebugging", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "int", "port", "", "void"), 223);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableRemoteDebugging", "com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment", "", "", "", "void"), 235);
    }
}

