/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.springcloud.AzureSpringCloud;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudClusterModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SpringCloudServiceSubscription
extends AbstractAzServiceSubscription<SpringCloudServiceSubscription, AppPlatformManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final SpringCloudClusterModule clusterModule;

    SpringCloudServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureSpringCloud service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.clusterModule = new SpringCloudClusterModule(this);
    }

    SpringCloudServiceSubscription(@Nonnull AppPlatformManager remote, @Nonnull AzureSpringCloud service) {
        this(remote.subscriptionId(), service);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.clusterModule);
    }

    @Nonnull
    public SpringCloudClusterModule clusters() {
        return this.clusterModule;
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.clusterModule.getName());
    }

    @Nonnull
    public ResourceManager getResourceManager() {
        return Objects.requireNonNull((AppPlatformManager)this.getRemote(new boolean[0])).resourceManager();
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public SpringCloudClusterModule getClusterModule() {
        return this.clusterModule;
    }
}

