/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.springcloud;

import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudAppInstance;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;
import rx.schedulers.Schedulers;

public class Utils {
    private static final int POLLING_INTERVAL = 5;

    public static boolean isDeploymentDone(@Nullable SpringCloudDeployment deployment) {
        if (deployment == null) {
            return false;
        }
        List<SpringCloudAppInstance> instances = deployment.getInstances();
        if (CollectionUtils.isEmpty(instances)) {
            return false;
        }
        return instances.stream().anyMatch(instance -> StringUtils.equalsIgnoreCase((CharSequence)instance.getStatus(), (CharSequence)"running"));
    }

    public static <T> T pollUntil(Callable<T> callable, @Nonnull Predicate<T> predicate, int timeOutInSeconds) {
        return Utils.pollUntil(callable, predicate, timeOutInSeconds, 5);
    }

    public static <T> T pollUntil(Callable<T> callable, @Nonnull Predicate<T> predicate, int timeOutInSeconds, int pollingInterval) {
        long timeout = System.currentTimeMillis() + (long)timeOutInSeconds * 1000L;
        return (T)Observable.interval((long)pollingInterval, (TimeUnit)TimeUnit.SECONDS).timeout((long)timeOutInSeconds, TimeUnit.SECONDS).flatMap(aLong -> Observable.fromCallable((Callable)callable)).subscribeOn(Schedulers.io()).takeUntil(resource -> predicate.test(resource) || System.currentTimeMillis() > timeout).toBlocking().last();
    }
}

