/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.google.common.io.Files;
import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.handlers.artifact.ArtifactHandlerBase;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.webapp.handlers.artifact.ArtifactHandlerUtils;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class WarArtifactHandlerImpl
extends ArtifactHandlerBase {
    protected final String warFile;
    protected final String contextPath;
    public static final String FILE_IS_NOT_WAR = "The deployment file is not a war typed file.";
    public static final String FIND_WAR_FILE_FAIL = "Failed to find the war file: '%s'";
    public static final String UPLOAD_FAILURE = "Exception occurred when deploying war file to server: %s, retrying immediately (%d/%d)";
    public static final String DEPLOY_FAILURE = "Failed to deploy war file after %d times of retry.";
    public static final int DEFAULT_MAX_RETRY_TIMES = 3;

    protected WarArtifactHandlerImpl(Builder builder) {
        super((ArtifactHandlerBase.Builder)builder);
        this.contextPath = builder.contextPath;
        this.warFile = builder.warFile;
    }

    public void publish(DeployTarget target) throws AzureExecutionException {
        File war = this.getWarFile();
        this.assureWarFileExisted(war);
        Runnable warDeployExecutor = ArtifactHandlerUtils.getRealWarDeployExecutor(target, war, this.getContextPath());
        Log.info((String)String.format("Trying to deploy artifact to %s...", target.getName()));
        Log.info((String)"Deploying the war file...");
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                warDeployExecutor.run();
                Log.info((String)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
                return;
            }
            catch (Exception e) {
                Log.debug((String)String.format(UPLOAD_FAILURE, e.getMessage(), retryCount, 3));
                continue;
            }
        }
        throw new AzureExecutionException(String.format(DEPLOY_FAILURE, 3));
    }

    protected String getContextPath() {
        String path = this.contextPath.trim();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    protected File getWarFile() {
        return StringUtils.isNotEmpty((CharSequence)this.warFile) ? new File(this.warFile) : new File(this.project.getArtifactFile().toString());
    }

    protected void assureWarFileExisted(File war) throws AzureExecutionException {
        if (!Files.getFileExtension((String)war.getName()).equalsIgnoreCase("war")) {
            throw new AzureExecutionException(FILE_IS_NOT_WAR);
        }
        if (!war.exists() || !war.isFile()) {
            throw new AzureExecutionException(String.format(FIND_WAR_FILE_FAIL, war.getAbsolutePath()));
        }
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        private String warFile;
        private String contextPath;

        protected Builder self() {
            return this;
        }

        public WarArtifactHandlerImpl build() {
            return new WarArtifactHandlerImpl(this);
        }

        public Builder warFile(String value) {
            this.warFile = value;
            return this.self();
        }

        public Builder contextPath(String value) {
            this.contextPath = value;
            return this.self();
        }
    }
}

