/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.handlers.runtime.WebAppRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public class PrivateDockerHubRuntimeHandlerImpl
extends WebAppRuntimeHandler {
    protected IDockerCredentialProvider dockerCredentialProvider;

    private PrivateDockerHubRuntimeHandlerImpl(Builder builder) {
        super(builder);
        this.dockerCredentialProvider = builder.dockerCredentialProvider;
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException {
        AppServicePlan plan = this.createOrGetAppServicePlan();
        return WebAppUtils.defineLinuxApp(this.resourceGroup, this.appName, this.azure, plan).withPrivateDockerHubImage(this.image).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws AzureExecutionException {
        WebAppUtils.assureLinuxWebApp(app);
        return ((WebApp.Update)app.update()).withPrivateDockerHubImage(this.image).withCredentials(this.dockerCredentialProvider.getUsername(), this.dockerCredentialProvider.getPassword());
    }

    @Override
    protected OperatingSystem getAppServicePlatform() {
        return OperatingSystem.LINUX;
    }

    public static class Builder
    extends WebAppRuntimeHandler.Builder<Builder> {
        protected IDockerCredentialProvider dockerCredentialProvider;

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PrivateDockerHubRuntimeHandlerImpl build() {
            return new PrivateDockerHubRuntimeHandlerImpl(this);
        }

        public Builder dockerCredentialProvider(IDockerCredentialProvider value) {
            this.dockerCredentialProvider = value;
            return this.self();
        }
    }
}

