// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.microsoft.aad.msal4j;

import java.util.Objects;

final class ClientAssertion implements IClientAssertion {

    static final String ASSERTION_TYPE_JWT_BEARER = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private final String assertion;

    ClientAssertion(final String assertion) {
        if (StringHelper.isBlank(assertion)) {
            throw new NullPointerException("assertion");
        }

        this.assertion = assertion;
    }

    public String assertion() {
        return this.assertion;
    }

    //These methods are based on those generated by Lombok's @EqualsAndHashCode annotation.
    //They have the same functionality as the generated methods, but were refactored for readability.
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ClientAssertion)) return false;

        ClientAssertion other = (ClientAssertion) o;
        return Objects.equals(assertion(), other.assertion());
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.assertion == null ? 43 : this.assertion.hashCode());
        return result;
    }
}