/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.messaging.listener;

import com.microsoft.azure.spring.messaging.listener.AzureMessageHandler;
import com.microsoft.azure.spring.messaging.listener.ListenerExecutionFailedException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class DefaultAzureMessageHandler
implements AzureMessageHandler {
    @Nullable
    private InvocableHandlerMethod handlerMethod;
    private Class<?> messagePayloadType;

    private String createMessagingErrorMessage(String description) {
        InvocableHandlerMethod handlerMethod = this.getHandlerMethod();
        StringBuilder sb = new StringBuilder(description).append("\n").append("Endpoint handler details:\n").append("Method [").append(handlerMethod.getMethod()).append("]\n").append("Bean [").append(handlerMethod.getBean()).append("]\n");
        return sb.toString();
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        InvocableHandlerMethod handlerMethod = this.getHandlerMethod();
        try {
            handlerMethod.invoke(message, new Object[0]);
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with incoming message"), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + handlerMethod.getMethod().toGenericString() + "' threw exception", ex);
        }
    }

    private Class<?> resolveMessagePayloadType(InvocableHandlerMethod method) {
        Object[] parameterTypes = method.getMethod().getParameterTypes();
        Assert.notEmpty((Object[])parameterTypes, (String)"Azure message handler method should not have empty parameters");
        return parameterTypes[0];
    }

    public InvocableHandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public void setHandlerMethod(InvocableHandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
        this.messagePayloadType = this.resolveMessagePayloadType(this.handlerMethod);
    }

    @Override
    public Class<?> getMessagePayloadType() {
        return this.messagePayloadType;
    }
}

