/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb;

import com.azure.data.cosmos.ConnectionPolicy;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.CosmosClient;
import com.microsoft.azure.spring.data.cosmosdb.common.MacAddress;
import com.microsoft.azure.spring.data.cosmosdb.common.PropertyLoader;
import com.microsoft.azure.spring.data.cosmosdb.common.TelemetrySender;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import java.util.Locale;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CosmosDbFactory {
    private final DocumentDBConfig config;
    private static final boolean IS_TELEMETRY_ALLOWED = PropertyLoader.isApplicationTelemetryAllowed();
    private static final String USER_AGENT_SUFFIX = "spring-data/" + PropertyLoader.getProjectVersion();

    private String getUserAgentSuffix() {
        String suffix = ";" + USER_AGENT_SUFFIX;
        if (IS_TELEMETRY_ALLOWED) {
            suffix = suffix + ";" + MacAddress.getHashMac();
        }
        return suffix;
    }

    public CosmosDbFactory(@NonNull DocumentDBConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.validateConfig(config);
        this.config = config;
    }

    public CosmosClient getCosmosClient() {
        ConnectionPolicy policy = ConnectionPolicy.defaultPolicy();
        String userAgent = this.getUserAgentSuffix() + ";" + this.config.getConnectionPolicy().getUserAgentSuffix();
        policy.userAgentSuffix(userAgent);
        String consistencyLevelString = null;
        if (this.config.getConsistencyLevel() != null) {
            consistencyLevelString = this.config.getConsistencyLevel().name().toUpperCase(Locale.getDefault());
        }
        return CosmosClient.builder().endpoint(this.config.getUri()).key(this.config.getKey()).cosmosKeyCredential(this.config.getCosmosKeyCredential()).connectionPolicy(policy).consistencyLevel(consistencyLevelString != null ? ConsistencyLevel.valueOf((String)consistencyLevelString) : ConsistencyLevel.SESSION).build();
    }

    private void validateConfig(@NonNull DocumentDBConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        Assert.hasText((String)config.getUri(), (String)"cosmosdb host url should have text!");
        if (config.getCosmosKeyCredential() == null) {
            Assert.hasText((String)config.getKey(), (String)"cosmosdb host key should have text!");
        } else if (StringUtils.isEmpty((Object)config.getKey())) {
            Assert.hasText((String)config.getCosmosKeyCredential().key(), (String)"cosmosdb credential host key should have text!");
        }
        Assert.hasText((String)config.getDatabase(), (String)"cosmosdb database should have text!");
        Assert.notNull((Object)config.getConnectionPolicy(), (String)"cosmosdb connection policy should not be null!");
    }

    @PostConstruct
    private void sendTelemetry() {
        if (IS_TELEMETRY_ALLOWED) {
            TelemetrySender sender = new TelemetrySender();
            sender.send(this.getClass().getSimpleName());
        }
    }

    public DocumentDBConfig getConfig() {
        return this.config;
    }
}

