/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.ObjectMapperFactory;
import com.microsoft.azure.spring.data.cosmosdb.exception.ConfigurationException;
import java.io.IOException;
import lombok.NonNull;

public class CosmosdbUtils {
    public static <T> T getCopyFrom(@NonNull T instance) {
        if (instance == null) {
            throw new NullPointerException("instance");
        }
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        try {
            String s = mapper.writeValueAsString(instance);
            return (T)mapper.readValue(s, instance.getClass());
        }
        catch (IOException e) {
            throw new ConfigurationException("failed to get copy from " + instance.getClass().getName(), e);
        }
    }
}

