/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.lang.NonNull;

public class PropertyLoader {
    private static final String PROJECT_PROPERTY_FILE = "/META-INF/project.properties";
    private static final String APPLICATION_PROPERTY_FILE = "/application.properties";
    private static final String APPLICATION_YML_FILE = "/application.yml";
    private static final String TELEMETRY_CONFIG_FILE = "/telemetry.config";

    public static String getProjectVersion() {
        return PropertyLoader.getPropertyByName("project.version", PROJECT_PROPERTY_FILE);
    }

    public static String getTelemetryInstrumentationKey() {
        return PropertyLoader.getPropertyByName("telemetry.instrumentationKey", TELEMETRY_CONFIG_FILE);
    }

    public static boolean isApplicationTelemetryAllowed() {
        String allowed = PropertyLoader.getPropertyByName("cosmosdb.telemetryAllowed", APPLICATION_PROPERTY_FILE);
        if (allowed == null) {
            allowed = PropertyLoader.getPropertyByName("telemetryAllowed", APPLICATION_YML_FILE);
        }
        if (allowed == null) {
            return true;
        }
        return !allowed.equalsIgnoreCase("false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPropertyByName(@NonNull String name, @NonNull String filename) {
        Properties properties = new Properties();
        InputStream inputStream = PropertyLoader.class.getResourceAsStream(filename);
        if (inputStream == null) {
            return null;
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties.getProperty(name);
    }

    private PropertyLoader() {
    }
}

