/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.azure.data.cosmos.AccessCondition;
import com.azure.data.cosmos.AccessConditionType;
import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.CosmosItemResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.SqlQuerySpec;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.spring.data.cosmosdb.CosmosDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.common.Memoizer;
import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingDocumentDbConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.CountQueryGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.FindQuerySpecGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentDbPageRequest;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.exception.DocumentDBAccessException;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.DocumentDbEntityInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public class DocumentDbTemplate
implements DocumentDbOperations,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DocumentDbTemplate.class);
    private static final String COUNT_VALUE_KEY = "_aggregate";
    private final MappingDocumentDbConverter mappingDocumentDbConverter;
    private final String databaseName;
    private final CosmosClient cosmosClient;
    private Function<Class<?>, DocumentDbEntityInformation<?, ?>> entityInfoCreator = Memoizer.memoize(this::getDocumentDbEntityInformation);

    public DocumentDbTemplate(CosmosDbFactory cosmosDbFactory, MappingDocumentDbConverter mappingDocumentDbConverter, String dbName) {
        Assert.notNull((Object)cosmosDbFactory, (String)"CosmosDbFactory must not be null!");
        Assert.notNull((Object)mappingDocumentDbConverter, (String)"MappingDocumentDbConverter must not be null!");
        this.mappingDocumentDbConverter = mappingDocumentDbConverter;
        this.databaseName = dbName;
        this.cosmosClient = cosmosDbFactory.getCosmosClient();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public <T> T insert(T objectToSave, com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        Assert.notNull(objectToSave, (String)"entityClass should not be null");
        return this.insert(this.getCollectionName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    @Override
    public <T> T insert(String collectionName, T objectToSave, com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        CosmosItemProperties originalItem = this.mappingDocumentDbConverter.writeCosmosItemProperties(objectToSave);
        log.debug("execute createDocument in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
        try {
            CosmosItemRequestOptions options = new CosmosItemRequestOptions();
            options.partitionKey(this.toCosmosPartitionKey(partitionKey));
            Class<?> domainClass = objectToSave.getClass();
            CosmosItemResponse response = (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).createItem((Object)originalItem, options).onErrorResume(this::databaseAccessExceptionHandler).block();
            if (response == null) {
                throw new DocumentDBAccessException("Failed to insert item");
            }
            return (T)this.mappingDocumentDbConverter.read(domainClass, response.properties());
        }
        catch (Exception e) {
            throw new DocumentDBAccessException("insert exception", e);
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findById(this.getCollectionName(entityClass), id, entityClass);
    }

    @Override
    public <T> T findById(String collectionName, Object id, Class<T> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(domainClass, (String)"entityClass should not be null");
        this.assertValidId(id);
        try {
            String query = String.format("select * from root where root.id = '%s'", id.toString());
            FeedOptions options = new FeedOptions();
            options.enableCrossPartitionQuery(Boolean.valueOf(true));
            return (T)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(query, options).flatMap(cosmosItemFeedResponse -> Mono.justOrEmpty(cosmosItemFeedResponse.results().stream().map(cosmosItem -> this.mappingDocumentDbConverter.read(domainClass, (CosmosItemProperties)cosmosItem)).findFirst())).onErrorResume(e -> {
                CosmosClientException cosmosClientException;
                if (e instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)e).statusCode() == 404) {
                    return Mono.empty();
                }
                return Mono.error((Throwable)e);
            }).blockFirst();
        }
        catch (Exception e2) {
            throw new DocumentDBAccessException("findById exception", e2);
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        this.assertValidId(id);
        PartitionKey pk = this.toCosmosPartitionKey(partitionKey);
        try {
            String collectionName = this.getCollectionName(entityClass);
            return (T)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).getItem(id.toString(), (Object)pk).read().flatMap(cosmosItemResponse -> Mono.justOrEmpty(this.toDomainObject(entityClass, cosmosItemResponse.properties()))).onErrorResume(e -> {
                CosmosClientException cosmosClientException;
                if (e instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)e).statusCode() == 404) {
                    return Mono.empty();
                }
                return Mono.error((Throwable)e);
            }).block();
        }
        catch (Exception e2) {
            throw new DocumentDBAccessException("findById exception", e2);
        }
    }

    @Override
    public <T> void upsert(T object, com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        Assert.notNull(object, (String)"Upsert object should not be null");
        this.upsert(this.getCollectionName(object.getClass()), object, partitionKey);
    }

    @Override
    public <T> void upsert(String collectionName, T object, com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(object, (String)"Upsert object should not be null");
        try {
            CosmosItemProperties originalItem = this.mappingDocumentDbConverter.writeCosmosItemProperties(object);
            log.debug("execute upsert document in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
            CosmosItemRequestOptions options = new CosmosItemRequestOptions();
            options.partitionKey(this.toCosmosPartitionKey(partitionKey));
            this.applyVersioning(object.getClass(), originalItem, options);
            CosmosItemResponse cosmosItemResponse = (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).upsertItem((Object)originalItem, options).onErrorResume(this::databaseAccessExceptionHandler).block();
            if (cosmosItemResponse == null) {
                throw new DocumentDBAccessException("Failed to upsert item");
            }
        }
        catch (Exception ex) {
            throw new DocumentDBAccessException("Failed to upsert document to database.", ex);
        }
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findAll(this.getCollectionName(entityClass), entityClass);
    }

    @Override
    public <T> List<T> findAll(String collectionName, Class<T> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(domainClass, (String)"entityClass should not be null");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        List<CosmosItemProperties> documents = this.findDocuments(query, domainClass, collectionName);
        return documents.stream().map(d -> this.getConverter().read(domainClass, (CosmosItemProperties)d)).collect(Collectors.toList());
    }

    @Override
    public void deleteAll(@NonNull String collectionName, @NonNull Class<?> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        this.delete(query, domainClass, collectionName);
    }

    @Override
    public void deleteCollection(@NonNull String collectionName) {
        Assert.hasText((String)collectionName, (String)"collectionName should have text.");
        try {
            this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).delete().block();
        }
        catch (Exception e) {
            throw new DocumentDBAccessException("failed to delete collection: " + collectionName, e);
        }
    }

    @Override
    public String getCollectionName(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        return this.entityInfoCreator.apply(domainClass).getCollectionName();
    }

    @Override
    public DocumentCollection createCollectionIfNotExists(@NonNull DocumentDbEntityInformation<?, ?> information) {
        CosmosContainerResponse response = (CosmosContainerResponse)this.cosmosClient.createDatabaseIfNotExists(this.databaseName).flatMap(cosmosDatabaseResponse -> cosmosDatabaseResponse.database().createContainerIfNotExists(information.getCollectionName(), "/" + information.getPartitionKeyFieldName(), information.getRequestUnit().intValue())).block();
        if (response == null) {
            throw new DocumentDBAccessException("Failed to create collection");
        }
        return new DocumentCollection(response.properties().toJson());
    }

    @Override
    public void deleteById(String collectionName, Object id, com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        this.assertValidId(id);
        log.debug("execute deleteById in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
        PartitionKey pk = this.toCosmosPartitionKey(partitionKey);
        if (pk == null) {
            pk = PartitionKey.None;
        }
        try {
            CosmosItemRequestOptions options = new CosmosItemRequestOptions();
            options.partitionKey(pk);
            this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).getItem(id.toString(), (Object)partitionKey).delete(options).onErrorResume(this::databaseAccessExceptionHandler).then().block();
        }
        catch (Exception e) {
            throw new DocumentDBAccessException("deleteById exception", e);
        }
    }

    @Override
    public <T, ID> List<T> findByIds(Iterable<ID> ids, Class<T> entityClass, String collectionName) {
        Assert.notNull(ids, (String)"Id list should not be null");
        Assert.notNull(entityClass, (String)"entityClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.IN, "id", Collections.singletonList(ids)));
        return this.find(query, entityClass, collectionName);
    }

    @Override
    public <T> List<T> find(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, String collectionName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainClass, (String)"domainClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        try {
            return this.findDocuments(query, domainClass, collectionName).stream().map(cosmosItemProperties -> this.toDomainObject(domainClass, (CosmosItemProperties)cosmosItemProperties)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new DocumentDBAccessException("Failed to execute find operation from " + collectionName, e);
        }
    }

    @Override
    public <T> Boolean exists(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, String collectionName) {
        return this.find(query, domainClass, collectionName).size() > 0;
    }

    @Override
    public <T> List<T> delete(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, @NonNull String collectionName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainClass, (String)"domainClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        List<CosmosItemProperties> results = this.findDocuments(query, domainClass, collectionName);
        List<String> partitionKeyName = this.getPartitionKeyNames(domainClass);
        results.forEach(d -> this.deleteDocument((CosmosItemProperties)d, partitionKeyName, collectionName, domainClass));
        return results.stream().map(d -> this.getConverter().read(domainClass, (CosmosItemProperties)d)).collect(Collectors.toList());
    }

    @Override
    public <T> Page<T> findAll(Pageable pageable, Class<T> domainClass, String collectionName) {
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(pageable);
        if (pageable.getSort().isSorted()) {
            query.with(pageable.getSort());
        }
        return this.paginationQuery(query, domainClass, collectionName);
    }

    @Override
    public <T> Page<T> paginationQuery(DocumentQuery query, Class<T> domainClass, String collectionName) {
        Assert.isTrue((query.getPageable().getPageSize() > 0 ? 1 : 0) != 0, (String)"pageable should have page size larger than 0");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        Pageable pageable = query.getPageable();
        FeedOptions feedOptions = new FeedOptions();
        if (pageable instanceof DocumentDbPageRequest) {
            feedOptions.requestContinuation(((DocumentDbPageRequest)pageable).getRequestContinuation());
        }
        feedOptions.maxItemCount(Integer.valueOf(pageable.getPageSize()));
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass))));
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        FeedResponse feedResponse = (FeedResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(sqlQuerySpec, feedOptions).next().block();
        if (feedResponse == null) {
            throw new DocumentDBAccessException("Failed to query documents");
        }
        Iterator it = feedResponse.results().iterator();
        ArrayList<T> result = new ArrayList<T>();
        for (int index = 0; it.hasNext() && index < pageable.getPageSize(); ++index) {
            CosmosItemProperties cosmosItemProperties = (CosmosItemProperties)it.next();
            if (cosmosItemProperties == null) continue;
            T entity = this.mappingDocumentDbConverter.read(domainClass, cosmosItemProperties);
            result.add(entity);
        }
        DocumentDbPageRequest pageRequest = DocumentDbPageRequest.of(pageable.getPageNumber(), pageable.getPageSize(), feedResponse.continuationToken(), query.getSort());
        return new PageImpl(result, (Pageable)pageRequest, this.count(query, domainClass, collectionName));
    }

    @Override
    public long count(String collectionName) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be empty");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        Long count = this.getCountValue(query, true, collectionName);
        if (count == null) {
            throw new DocumentDBAccessException("Failed to get count for collectionName: " + collectionName);
        }
        return count;
    }

    @Override
    public <T> long count(DocumentQuery query, Class<T> domainClass, String collectionName) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        Assert.hasText((String)collectionName, (String)"collectionName should not be empty");
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        Long count = this.getCountValue(query, isCrossPartitionQuery, collectionName);
        if (count == null) {
            throw new DocumentDBAccessException("Failed to get count for collectionName: " + collectionName);
        }
        return count;
    }

    @Override
    public MappingDocumentDbConverter getConverter() {
        return this.mappingDocumentDbConverter;
    }

    private Long getCountValue(DocumentQuery query, boolean isCrossPartitionQuery, String containerName) {
        SqlQuerySpec querySpec = new CountQueryGenerator().generateCosmos(query);
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        return (Long)this.executeQuery(querySpec, containerName, options).onErrorResume(this::databaseAccessExceptionHandler).next().map(r -> ((CosmosItemProperties)r.results().get(0)).getLong(COUNT_VALUE_KEY)).block();
    }

    private <T> Mono<T> databaseAccessExceptionHandler(Throwable e) {
        throw new DocumentDBAccessException("failed to access cosmosdb database", e);
    }

    private Flux<FeedResponse<CosmosItemProperties>> executeQuery(SqlQuerySpec sqlQuerySpec, String collectionName, FeedOptions options) {
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(sqlQuerySpec, options);
    }

    private List<String> getPartitionKeyNames(Class<?> domainClass) {
        DocumentDbEntityInformation<?, ?> entityInfo = this.entityInfoCreator.apply(domainClass);
        if (entityInfo.getPartitionKeyFieldName() == null) {
            return new ArrayList<String>();
        }
        return Collections.singletonList(entityInfo.getPartitionKeyFieldName());
    }

    private PartitionKey toCosmosPartitionKey(com.microsoft.azure.documentdb.PartitionKey partitionKey) {
        if (partitionKey == null) {
            return null;
        }
        return PartitionKey.fromJsonString((String)partitionKey.getInternalPartitionKey().toJson());
    }

    private void assertValidId(Object id) {
        Assert.notNull((Object)id, (String)"id should not be null");
        if (id instanceof String) {
            Assert.hasText((String)id.toString(), (String)"id should not be empty or only whitespaces.");
        }
    }

    private List<CosmosItemProperties> findDocuments(@NonNull DocumentQuery query, @NonNull Class<?> domainClass, @NonNull String containerName) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        FeedOptions feedOptions = new FeedOptions();
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        return (List)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, feedOptions).flatMap(cosmosItemFeedResponse -> Flux.fromIterable((Iterable)cosmosItemFeedResponse.results())).collectList().block();
    }

    private CosmosItemResponse deleteDocument(@NonNull CosmosItemProperties cosmosItemProperties, @NonNull List<String> partitionKeyNames, String containerName, @NonNull Class<?> domainClass) {
        PartitionKey pk;
        Assert.isTrue((partitionKeyNames.size() <= 1 ? 1 : 0) != 0, (String)"Only one Partition is supported.");
        com.microsoft.azure.documentdb.PartitionKey partitionKey = null;
        if (!partitionKeyNames.isEmpty() && StringUtils.hasText((String)partitionKeyNames.get(0))) {
            partitionKey = new com.microsoft.azure.documentdb.PartitionKey(cosmosItemProperties.get(partitionKeyNames.get(0)));
        }
        if ((pk = this.toCosmosPartitionKey(partitionKey)) == null) {
            pk = PartitionKey.None;
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions((Object)pk);
        this.applyVersioning(domainClass, cosmosItemProperties, options);
        return (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(cosmosItemProperties.id(), (Object)partitionKey).delete(options).block();
    }

    private <T> T toDomainObject(@NonNull Class<T> domainClass, CosmosItemProperties cosmosItemProperties) {
        return this.mappingDocumentDbConverter.read(domainClass, cosmosItemProperties);
    }

    private void applyVersioning(Class<?> domainClass, CosmosItemProperties cosmosItemProperties, CosmosItemRequestOptions options) {
        if (this.entityInfoCreator.apply(domainClass).isVersioned()) {
            AccessCondition accessCondition = new AccessCondition();
            accessCondition.type(AccessConditionType.IF_MATCH);
            accessCondition.condition(cosmosItemProperties.etag());
            options.accessCondition(accessCondition);
        }
    }

    private DocumentDbEntityInformation<?, ?> getDocumentDbEntityInformation(Class<?> domainClass) {
        return new DocumentDbEntityInformation(domainClass);
    }
}

